/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.medium.DeletedMedium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatisticInternal;
import xxx.scenerixx.scenerixxlib.model.statistic.StatisticInternal;
import xxx.scenerixx.scenerixxlib.util.ScenerixxCommonLib;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;

public class DeleteMovieFromDiscAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(DeleteMovieFromDiscAction.class.getName());
    private DB db = DB.getInstance();
    private ScenerixxCommon common = new ScenerixxCommon();

    public DeleteMovieFromDiscAction() {
        Image image = ImageUtilities.loadImage((String)"icons/Delete.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        List mediumFiles;
        int selectedMovies = 0;
        long fileSize = 0L;
        int associatedFilesCount = 0;
        ArrayList<Movie> movies = new ArrayList<Movie>();
        ArrayList<MediumFile> mediumFilesToDelete = new ArrayList<MediumFile>();
        int selectedMediumFiles = 0;
        long mediumFileSize = 0L;
        for (Node n : activatedNodes) {
            MediumFile mf;
            Object mediumFiles2;
            Object mf22;
            if (n.getValue("movie") != null && n.getValue("movie") instanceof Movie) {
                movies.add((Movie)n.getValue("movie"));
                ++selectedMovies;
                mediumFiles = this.db.getMediumFiles((Movie)n.getValue("movie"), Scenerixx.unlocked);
                associatedFilesCount += mediumFiles.size();
                for (Object mf22 : mediumFiles) {
                    fileSize += mf22.getFileSize().longValue();
                }
            }
            if (n.getValue("entry") == null || !(n.getValue("entry") instanceof PlaylistEntry)) continue;
            PlaylistEntry pe = (PlaylistEntry)n.getValue("entry");
            if (pe.getMovie() != null) {
                movies.add(pe.getMovie());
                ++selectedMovies;
                mediumFiles2 = this.db.getMediumFiles(pe.getMovie(), Scenerixx.unlocked);
                associatedFilesCount += mediumFiles2.size();
                mf22 = mediumFiles2.iterator();
                while (mf22.hasNext()) {
                    mf = (MediumFile)mf22.next();
                    fileSize += mf.getFileSize().longValue();
                }
            }
            if (pe.getScene() != null) {
                movies.add(pe.getScene().getMovieAssociated());
                ++selectedMovies;
                mediumFiles2 = this.db.getMediumFiles(pe.getScene().getMovieAssociated(), Scenerixx.unlocked);
                associatedFilesCount += mediumFiles2.size();
                mf22 = mediumFiles2.iterator();
                while (mf22.hasNext()) {
                    mf = (MediumFile)mf22.next();
                    fileSize += mf.getFileSize().longValue();
                }
            }
            if (pe.getBookmark() != null) {
                movies.add(pe.getBookmark().getMovieAssociated());
                ++selectedMovies;
                mediumFiles2 = this.db.getMediumFiles(pe.getBookmark().getMovieAssociated(), Scenerixx.unlocked);
                associatedFilesCount += mediumFiles2.size();
                mf22 = mediumFiles2.iterator();
                while (mf22.hasNext()) {
                    mf = (MediumFile)mf22.next();
                    fileSize += mf.getFileSize().longValue();
                }
            }
            if (pe.getMediumFile() == null) continue;
            mediumFilesToDelete.add(pe.getMediumFile());
            ++selectedMediumFiles;
            mediumFileSize += pe.getMediumFile().getFileSize().longValue();
        }
        Object filesToDelete = "";
        int cntFilesToDelete = 0;
        for (Movie movie : movies) {
            filesToDelete = (String)filesToDelete + "\n\nMovie:\n" + movie.getTitle() + "\n\nAssociated files:\n";
            mediumFiles = this.db.getMediumFiles(movie, Scenerixx.unlocked);
            for (Object mf22 : mediumFiles) {
                filesToDelete = (String)filesToDelete + ++cntFilesToDelete + ". " + mf22.getFileCompletePath() + " [" + ScenerixxCommon.readableFileSize(mf22.getFileSize()) + "]\n";
            }
        }
        if (cntFilesToDelete > 10) {
            filesToDelete = "";
        }
        if (!mediumFilesToDelete.isEmpty()) {
            if (0 == JOptionPane.showConfirmDialog(null, "Should " + ScenerixxCommon.singularPlural(selectedMediumFiles, "medium file", "medium files", true) + " [" + ScenerixxCommon.readableFileSize(mediumFileSize) + "]) really get deleted?", "Delete medium files from disc?", 0)) {
                for (MediumFile mf : mediumFilesToDelete) {
                    File f = new File(mf.getFileCompletePath());
                    boolean deleted = f.delete();
                    if (!deleted) {
                        JOptionPane.showMessageDialog(null, "File '" + mf.getFileCompletePath() + "' could not be deleted!", "Error", 0);
                    } else {
                        this.db.deleteMediumFile(mf, true);
                        this.common.checkEmptyDirectoryAndDeleteIfWanted(mf);
                        DeletedMedium dm = new DeletedMedium();
                        dm.setHashValue(mf.getHashValue());
                        dm = (DeletedMedium)this.db.getEntityService().save((AbstractEntity)dm);
                    }
                    AbstractTopComponent.dirtyMediumFileList();
                    AbstractTopComponent.reloadPlaylist();
                }
            }
        }
        if (!movies.isEmpty()) {
            if (0 == JOptionPane.showConfirmDialog(null, "Should " + ScenerixxCommon.singularPlural(selectedMovies, "movie", "movies", true) + ", including ALL associated files (" + ScenerixxCommon.singularPlural(associatedFilesCount, "file", "files", true) + " [" + ScenerixxCommon.readableFileSize(fileSize) + "]), really get deleted?" + (String)filesToDelete, "Delete movie and files from disc?", 0)) {
                for (Movie movie : movies) {
                    mediumFiles = this.db.getMediumFiles(movie, Scenerixx.unlocked);
                    for (Object mf22 : mediumFiles) {
                        File f = new File(mf22.getFileCompletePath());
                        boolean deleted = f.delete();
                        if (!deleted) {
                            JOptionPane.showMessageDialog(null, "File '" + mf22.getFileCompletePath() + "' could not be deleted!", "Error", 0);
                            continue;
                        }
                        DeletedMedium dm = new DeletedMedium();
                        dm.setHashValue(mf22.getHashValue());
                        dm = (DeletedMedium)this.db.getEntityService().save((AbstractEntity)dm);
                        LOG.info("Delete screencaps");
                        try {
                            Stream<Path> paths = Files.walk(Paths.get(Scenerixx.scenerixxScreencapDir, new String[0]), new FileVisitOption[0]).filter(p -> p.getFileName().toString().startsWith(movie.getId() + "_"));
                            try {
                                List screencaps = paths.collect(Collectors.toList());
                                LOG.info("found " + screencaps.size() + " screencaps to delete");
                                for (Path filePath : screencaps) {
                                    if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                                    try {
                                        LOG.finest("Possible screencap: " + filePath.toString());
                                        if (new File(filePath.toString()).delete()) {
                                            LOG.info("Deleted screencap: " + filePath.toString());
                                            continue;
                                        }
                                        LOG.info("Error while deleting screencap: " + filePath.toString());
                                    }
                                    catch (Exception ex) {
                                        LOG.fine("Error while trying to find screencaps: " + ex.getMessage());
                                    }
                                }
                            }
                            finally {
                                if (paths == null) continue;
                                paths.close();
                            }
                        }
                        catch (IOException ex) {
                            LOG.fine("Error while trying to find screencaps: " + ex.getMessage());
                        }
                    }
                    LOG.info("Delete medium file entities");
                    for (Object mf22 : mediumFiles) {
                        mf22.setMovie(null);
                        this.db.deleteMediumFile((MediumFile)mf22, true);
                        this.common.checkEmptyDirectoryAndDeleteIfWanted((MediumFile)mf22);
                    }
                    StatisticInternal stats = (StatisticInternal)this.db.getEntityService().find((EntityPathBase)QStatisticInternal.statisticInternal).order(new Function[]{g -> g.dateOfCreation.desc()}).findFirst();
                    if (stats == null) {
                        stats = new StatisticInternal();
                    }
                    stats.setSavedBytes(stats.getSavedBytes() + fileSize);
                    stats = (StatisticInternal)this.db.getEntityService().save((AbstractEntity)stats);
                    LOG.info("Delete movie entity");
                    Movie movie2 = (Movie)this.db.getEntityService().load(Movie.class, movie.getId().longValue());
                    this.db.deleteMovie(movie2);
                    TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
                    if (movieList != null) {
                        ExplorerManager em = ((MovieListTopComponent)movieList).getExplorerManager();
                        for (Node selectedNode : em.getSelectedNodes()) {
                            selectedNode.setDisplayName("<html><font color=\"" + ScenerixxCommonLib.RED + "\">Deleted!</font> <strike>" + movie2.getTitle() + "</strike> (this node will be removed with the next reload)</html>");
                        }
                    }
                    LOG.info("Finished deleting movie " + movie.getTitle());
                }
                TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
                Movie nextMovie = ScenerixxCommon.readInNextNode(movieList);
                int tmpSelectedMovies = selectedMovies;
                SwingUtilities.invokeLater(() -> {
                    AbstractTopComponent.notifyInfo(ScenerixxCommon.singularPlural(tmpSelectedMovies, "movie", "movies", true) + " deleted");
                    LOG.info("set next node " + String.valueOf(nextMovie));
                    if (movieList != null) {
                        ((MovieListTopComponent)movieList).selectMovieNode(nextMovie);
                    }
                    AbstractTopComponent.dirtyMediumFileList();
                    AbstractTopComponent.dirtyPersonList();
                    AbstractTopComponent.reloadPlaylist();
                });
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        LOG.finer("activated nodes (delete action) " + activatedNodes.length);
        return true;
    }

    public String getName() {
        return "Delete movie & files from disc";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

