/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.medium.Medium;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class SwapMediumFilesAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(SwapMediumFilesAction.class.getName());
    private final DB db = DB.getInstance();

    public SwapMediumFilesAction() {
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/arrow_switch.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        boolean enable = false;
        if (activatedNodes.length == 2) {
            for (Node n : activatedNodes) {
                if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) {
                    enable = false;
                    break;
                }
                LOG.fine("it's a movie");
                enable = true;
            }
        }
        if (!enable) {
            AbstractTopComponent.notifyError("You need to select exactly two movie nodes.");
            return;
        }
        this.swap((Movie)activatedNodes[0].getValue("movie"), (Movie)activatedNodes[1].getValue("movie"));
    }

    public boolean swap(Movie first, Movie second) {
        int showInternalConfirmDialog = JOptionPane.showInternalConfirmDialog(null, "<html>Should we swap the medium files for the movies?</html>", "Swap medium files?", 0, 1);
        boolean doSwap = true;
        if (showInternalConfirmDialog == 0) {
            Movie one = first;
            Movie other = second;
            if (one.getTotalRuntime() != other.getTotalRuntime()) {
                int diffRuntime = JOptionPane.showInternalConfirmDialog(null, "<html>Runtime is different! Swap anyway?</html>", "Swap medium files even though runtime is different?", 0, 1);
                if (diffRuntime == 0) {
                    doSwap = true;
                } else {
                    AbstractTopComponent.notifyInfo("Aborted swapping!");
                    doSwap = false;
                }
            }
            if (doSwap) {
                List mediumFilesOne = this.db.getMediumFiles(one, true);
                List mediumFilesOther = this.db.getMediumFiles(other, true);
                if (mediumFilesOne.size() != 1 || mediumFilesOther.size() != 1) {
                    LOG.info("not exactly one medium file assigned");
                    AbstractTopComponent.notifyError("More than one medium file assigned. We cannot handle this. Abort.");
                    return false;
                }
                ((MediumFile)mediumFilesOne.get(0)).setMovie(other);
                this.db.getEntityService().save((AbstractEntity)((MediumFile)mediumFilesOne.get(0)));
                ((MediumFile)mediumFilesOther.get(0)).setMovie(one);
                this.db.getEntityService().save((AbstractEntity)((MediumFile)mediumFilesOther.get(0)));
                for (Scene s : one.getScenes()) {
                    if (s.getStartMedium() != null) {
                        s.setStartMedium((Medium)mediumFilesOther.get(0));
                    }
                    if (s.getEndMedium() != null) {
                        s.setEndMedium((Medium)mediumFilesOther.get(0));
                    }
                    this.db.getEntityService().save((AbstractEntity)s);
                }
                for (Scene s : other.getScenes()) {
                    if (s.getStartMedium() != null) {
                        s.setStartMedium((Medium)mediumFilesOne.get(0));
                    }
                    if (s.getEndMedium() != null) {
                        s.setEndMedium((Medium)mediumFilesOne.get(0));
                    }
                    this.db.getEntityService().save((AbstractEntity)s);
                }
            }
            AbstractTopComponent.notifyInfo("Medium files have been swapped.");
        }
        return doSwap;
    }

    protected boolean enable(Node[] activatedNodes) {
        LOG.finer("Check if SwapMediumFilesAction is enabled");
        boolean enable = false;
        if (activatedNodes.length == 2) {
            for (Node n : activatedNodes) {
                if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) {
                    enable = false;
                    break;
                }
                LOG.finer("it's a movie");
                enable = true;
            }
        } else {
            LOG.finer("Exactly two movies needs to be selected. Selected: " + activatedNodes.length);
        }
        return enable;
    }

    public String getName() {
        return "Swap medium files";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

