/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.movie.action;

import java.awt.Image;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;

public class UnsetSecretAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(UnsetSecretAction.class.getName());
    private DB db = DB.getInstance();
    private ScenerixxCommon common = new ScenerixxCommon();

    public UnsetSecretAction() {
        Image image = ImageUtilities.loadImage((String)"icons/Unlock.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        int selectedMovies = 0;
        for (Node n : activatedNodes) {
            if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) continue;
            ++selectedMovies;
        }
        if (0 == JOptionPane.showConfirmDialog(null, "Should we unset the secret flag for " + ScenerixxCommon.singularPlural(selectedMovies, "movie", "movies", true) + "?", "Unset secret flag?", 0)) {
            TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
            Movie nextMovie = ScenerixxCommon.readInNextNode(movieList);
            for (Node n : activatedNodes) {
                if (n.getValue("movie") == null || !(n.getValue("movie") instanceof Movie)) continue;
                LOG.fine("Unset secret flag for movie " + ((Movie)n.getValue("movie")).getNameOfPlayable());
                Movie movie = (Movie)n.getValue("movie");
                movie.setSecret(false);
                this.db.getEntityService().save((AbstractEntity)movie);
            }
            int tmpSelectedMovies = selectedMovies;
            SwingUtilities.invokeLater(() -> {
                AbstractTopComponent.notifyInfo("Unset secret flag for " + ScenerixxCommon.singularPlural(tmpSelectedMovies, "movie", "movies", true));
                ((MovieListTopComponent)movieList).reloadList();
                ((MovieListTopComponent)movieList).setNextNode(nextMovie);
            });
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Unset secret flag";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

