/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.person;

import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.SharedClassObject;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.SceneDetails;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.actions.ShowPicturesAction;
import xxx.scenerixx.scenerixxmodule.childfactories.mediumfile.MediumFileChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddToDefaultPlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.movie.action.AddToPlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.person.action.AddPersonAction;
import xxx.scenerixx.scenerixxmodule.childfactories.person.action.CreatePlaylistAction;
import xxx.scenerixx.scenerixxmodule.childfactories.person.action.DeletePersonAction;
import xxx.scenerixx.scenerixxmodule.childfactories.person.action.ExportPersonAction;
import xxx.scenerixx.scenerixxmodule.childfactories.person.action.ImportPersonAction;
import xxx.scenerixx.scenerixxmodule.childfactories.person.action.ResetICameCounterAction;
import xxx.scenerixx.scenerixxmodule.childfactories.person.action.SearchNameInMediumFilesAction;
import xxx.scenerixx.scenerixxmodule.childfactories.scene.CallableSceneChildFactory;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.RendererUtil;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.person.PersonListTopComponent;

public class PersonChildFactory
extends ChildFactory.Detachable<Person>
implements LookupListener {
    public static final Logger LOG = Logger.getLogger(PersonChildFactory.class.getName());
    private List<Person> resultList;
    private final DB db = DB.getInstance();
    private String suffix = "";
    private boolean showImportMenu = false;
    private boolean showNoOfApperance = true;
    private boolean showCounter = false;
    private boolean showLikeCounter = false;
    private boolean showBirthyear = false;
    private boolean showRating = false;
    private boolean showRuntime = false;
    private boolean showBirthdate = false;
    private boolean showPositionInList = false;
    private boolean showBirthdayMessageToday = false;
    private boolean showBirthdayMessageInXDays = false;
    private Lookup.Result<Person> results;

    public PersonChildFactory(List<Person> resultList, boolean showCounter, boolean showBirthyear, boolean showRating, boolean showLikeCounter, boolean showRuntime, boolean showBirthdate) {
        this(resultList, showCounter, showBirthyear, showRating, showLikeCounter, showRuntime, showBirthdate, false);
    }

    public PersonChildFactory(List<Person> resultList, boolean showCounter, boolean showBirthyear, boolean showRating, boolean showLikeCounter, boolean showRuntime, boolean showBirthdate, boolean showPositionInList) {
        this(resultList, showCounter, showBirthyear, showRating, showLikeCounter, showRuntime, showBirthdate, showPositionInList, false, false);
    }

    public PersonChildFactory(List<Person> resultList, boolean showCounter, boolean showBirthyear, boolean showRating, boolean showLikeCounter, boolean showRuntime, boolean showBirthdate, boolean showPositionInList, boolean showBirthdayMessageToday, boolean showBirthdayMessageInXDays) {
        this.resultList = resultList;
        this.showCounter = showCounter;
        this.showBirthyear = showBirthyear;
        this.showRating = showRating;
        this.showLikeCounter = showLikeCounter;
        this.showRuntime = showRuntime;
        this.showBirthdate = showBirthdate;
        this.showPositionInList = showPositionInList;
        this.showBirthdayMessageToday = showBirthdayMessageToday;
        this.showBirthdayMessageInXDays = showBirthdayMessageInXDays;
    }

    public PersonChildFactory(List<Person> resultList, String suffix, boolean showImportMenu, boolean showNoOfApperance) {
        this.resultList = resultList;
        this.showImportMenu = showImportMenu;
        if (!((String)suffix).startsWith(" ")) {
            suffix = " " + (String)suffix;
        }
        this.suffix = suffix;
        this.showNoOfApperance = showNoOfApperance;
    }

    public void reloadList(Node node) {
        LOG.finest("Hook method reloadList in PersonChildFactory");
    }

    protected boolean createKeys(List<Person> list) {
        int i = 1;
        for (Person p : this.resultList) {
            p.setPositionInList(i++);
            list.add(p);
        }
        return true;
    }

    protected Node createNodeForKey(final Person p) {
        LOG.finest("create new node for key. Person: " + String.valueOf(p));
        AbstractNode result = new AbstractNode(Children.createLazy((Callable)new CallableSceneChildFactory(p, this.showCounter, this.showLikeCounter, this.showRuntime, this.showRating, true)), Lookups.singleton((Object)p)){

            public Image getOpenedIcon(int type) {
                LocalDate today = LocalDate.now();
                if (!PersonChildFactory.this.showBirthdate && p.getBirthDay() != null && p.getBirthMonth() != null && today.getDayOfMonth() == p.getBirthDay().intValue() && today.getMonthValue() == p.getBirthMonth().intValue()) {
                    this.setShortDescription("Turns today " + new ScenerixxCommon().calculateAge(p));
                    return ImageUtilities.loadImage((String)"icons/Gift.png");
                }
                if (p.isRemindsMeOfFlag()) {
                    return ImageUtilities.loadImage((String)"icons.silk/award_star_gold_2.png");
                }
                if (p.isFavorite()) {
                    return ImageUtilities.loadImage((String)"icons/favourites.png");
                }
                if (Gender.FEMALE.equals((Object)p.getGender())) {
                    if (p.isAlias()) {
                        return ImageUtilities.loadImage((String)"icons/femaleperson.png");
                    }
                    Image image = ImageUtilities.loadImage((String)"icons/female.png");
                    image = ImageUtilities.mergeImages((Image)RendererUtil.getFlagImage(p.getNationality()), (Image)image, (int)9, (int)4);
                    return image;
                }
                if (Gender.MALE.equals((Object)p.getGender())) {
                    if (p.isAlias()) {
                        return ImageUtilities.loadImage((String)"icons/maleperson.png");
                    }
                    Image image = ImageUtilities.loadImage((String)"icons/male.png");
                    image = ImageUtilities.mergeImages((Image)RendererUtil.getFlagImage(p.getNationality()), (Image)image, (int)8, (int)4);
                    return image;
                }
                if (Gender.TS.equals((Object)p.getGender())) {
                    if (p.isAlias()) {
                        return ImageUtilities.loadImage((String)"icons/People.png");
                    }
                    Image image = ImageUtilities.loadImage((String)"icons2/transgender.png");
                    image = ImageUtilities.mergeImages((Image)RendererUtil.getFlagImage(p.getNationality()), (Image)image, (int)9, (int)4);
                    return image;
                }
                return super.getOpenedIcon(type);
            }

            public Image getIcon(int type) {
                return this.getOpenedIcon(type);
            }

            public PasteType createPasteType(final Transferable t, final int action, final AbstractNode nodeToSelectAfterReload) {
                return new PasteType(){

                    private void addMediumFileToPerson(MediumFile mediumFile) {
                        if (mediumFile != null) {
                            if (mediumFile.getHashValue() == null) {
                                JOptionPane.showMessageDialog(null, "The file '" + mediumFile.getFileName() + "' is not hashed yet. Please hash the file before you associate it.", "Abort", 0);
                            } else {
                                LOG.info("mediumfile '" + String.valueOf(mediumFile) + "' pasted to person " + p.getName());
                                p.setPicture(mediumFile);
                                PersonChildFactory.this.db.getEntityService().save((AbstractEntity)p);
                                AbstractTopComponent.reloadMediumFileList(Node.EMPTY);
                                AbstractTopComponent.reloadPersonList(p.getName());
                            }
                        }
                    }

                    public Transferable paste() throws IOException {
                        Node node = NodeTransfer.node((Transferable)t, (int)action);
                        if (node instanceof MediumFileChildFactory.MediumFileBeanNode) {
                            this.addMediumFileToPerson((MediumFile)node.getValue("mediumFile"));
                            PersonChildFactory.this.reloadList((Node)nodeToSelectAfterReload);
                        } else if (node != null && node.getValue("person") != null && node.getValue("person") instanceof Person) {
                            Person srcPerson = (Person)node.getValue("person");
                            LOG.info("pasted person " + srcPerson.getName() + " to " + p.getName());
                            if (0 == JOptionPane.showConfirmDialog(null, "Should '" + srcPerson.getName() + "' get merged into '" + p.getName() + "'. \n" + srcPerson.getName() + " will be deleted after the merge. This operation cannot be reverted!", "Merge persons?", 1, 2)) {
                                for (Scene s : srcPerson.getScenes(Scenerixx.unlocked)) {
                                    SceneDetails details = s.getDetails(srcPerson);
                                    if (details != null) {
                                        LOG.info("person before: " + details.getPerson().getName());
                                        details.setPerson(p);
                                        details = (SceneDetails)PersonChildFactory.this.db.getEntityService().save((AbstractEntity)details);
                                        LOG.info("person after: " + details.getPerson().getName());
                                        LOG.info("re-assigned scene details");
                                    } else {
                                        LOG.info("no scene details found for " + srcPerson.getName());
                                    }
                                    LOG.info("Replaced " + srcPerson.getName() + " with " + p.getName() + " in scene " + s.getNameOfPlayable());
                                }
                                PersonChildFactory.this.db.getEntityService().delete((AbstractEntity)srcPerson);
                                AbstractTopComponent.notifyInfo("Merged " + srcPerson.getName() + " with " + p.getName() + ". In case you have pictures of " + srcPerson.getName() + ": those you need to rename manually.");
                            }
                        } else {
                            String displayName = null;
                            if (node != null) {
                                displayName = node.getDisplayName();
                            }
                            LOG.fine("Something pasted to a person but not a MediumFile: " + displayName);
                        }
                        PersonChildFactory.this.refresh(true);
                        AbstractTopComponent.reloadPersonList(p.getName());
                        return null;
                    }
                };
            }

            public PasteType getDropType(Transferable t, int action, int index) {
                return this.createPasteType(t, action, this);
            }

            public Action[] getActions(boolean context) {
                Person person = (Person)this.getLookup().lookup(Person.class);
                ArrayList<Object> list = new ArrayList<Object>();
                if (PersonChildFactory.this.showImportMenu) {
                    list.add(SystemAction.get(ImportPersonAction.class));
                } else {
                    list.add((Action)SharedClassObject.findObject(SearchNameInMediumFilesAction.class, (boolean)true));
                    list.add(null);
                    list.add((Action)SharedClassObject.findObject(CreatePlaylistAction.class, (boolean)true));
                    list.add((Action)SharedClassObject.findObject(AddToDefaultPlaylistAction.class, (boolean)true));
                    list.add((Action)SharedClassObject.findObject(AddToPlaylistAction.class, (boolean)true));
                    list.add((Action)SharedClassObject.findObject(AddPersonAction.class, (boolean)true));
                    list.add(null);
                    ExportPersonAction exportAction = (ExportPersonAction)SharedClassObject.findObject(ExportPersonAction.class, (boolean)true);
                    DeletePersonAction deleteAction = (DeletePersonAction)SharedClassObject.findObject(DeletePersonAction.class, (boolean)true);
                    if (person.getName() != null && person.getName().startsWith("[Unknown")) {
                        exportAction.setEnabled(false);
                        deleteAction.setEnabled(false);
                    }
                    if (PersonChildFactory.this.db.getScenerixxSettings().isShowExport()) {
                        list.add((Object)exportAction);
                    }
                    if (p.getPicture() != null) {
                        list.add(new RemovePictureAction((Node)this));
                    }
                    list.add(null);
                    list.add((Action)SharedClassObject.findObject(ResetICameCounterAction.class, (boolean)true));
                    list.add((Object)deleteAction);
                }
                Action[] actions = new Action[list.size()];
                actions = list.toArray(actions);
                return actions;
            }

            public String getHtmlDisplayName() {
                return this.getDisplayName();
            }

            class RemovePictureAction
            extends AbstractAction {
                private Node node;

                public RemovePictureAction(Node node) {
                    this.node = node;
                    this.putValue("Name", "Remove Picture");
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Person obj = (Person)this.getLookup().lookup(Person.class);
                    obj = (Person)PersonChildFactory.this.db.getEntityService().load(Person.class, obj.getId().longValue());
                    obj.setPicture(null);
                    PersonChildFactory.this.db.getEntityService().save((AbstractEntity)obj);
                    LOG.finest("Removed picture from " + obj.getName());
                    PersonChildFactory.this.reloadList(this.node);
                    AbstractTopComponent.reloadPersonList(p.getName());
                }
            }
        };
        Object app = "";
        if (this.showBirthyear) {
            app = (String)app + " [";
            app = p.getBirthYear() != null ? (String)app + p.getBirthYear() : (String)app + "??";
            app = (String)app + "]";
        }
        if (this.showBirthdate) {
            app = (String)app + " [";
            app = p.getBirthDay() != null ? (String)app + p.getBirthDay() + "." : (String)app + "??.";
            app = p.getBirthMonth() != null ? (String)app + p.getBirthMonth() + "." : (String)app + "??.";
            app = p.getBirthYear() != null ? (String)app + p.getBirthYear() : (String)app + "??";
            app = (String)app + "]";
        }
        if (this.showRating) {
            int rating = 0;
            if (p.getRating() != null) {
                rating = p.getRating();
            }
            app = (String)app + " [" + ScenerixxCommon.getColoredStar(rating, p.getRatingDifferentiator()) + "]";
        }
        if (this.showNoOfApperance) {
            app = (String)app + " [" + ScenerixxCommon.getSumSymbol((int)this.db.getNumberOfAppearance(p, Scenerixx.unlocked)) + "]";
        }
        if (this.showLikeCounter) {
            app = (String)app + " [" + ScenerixxCommon.getColoredHeart(p.getIcame()) + "]";
        }
        if (this.showRuntime) {
            app = (String)app + " [" + new ScenerixxCommon().calculateTotalRuntime(p) + "]";
        }
        Object displayname = "";
        displayname = this.showBirthdayMessageInXDays ? p.getNameWithBirthdayInXDays(p.hasBirthday()) + (String)app + this.suffix : (this.showBirthdayMessageToday ? p.getNameWithBirthtoday(p.hasBirthday()) + (String)app + this.suffix : p.getName() + (String)app + this.suffix);
        if (this.showPositionInList) {
            displayname = p.getPositionInList() + ". " + (String)displayname;
        }
        if (!this.showBirthdate && p.hasBirthday()) {
            displayname = p.getHtmlDisplayedName() + (String)app + this.suffix;
        }
        result.setDisplayName((String)displayname);
        result.setValue("person", (Object)p);
        result.setName(p.getName());
        return result;
    }

    protected void addNotify() {
        super.addNotify();
        LOG.fine("PersonChildFactory ADD NOTIFY");
        this.results = Utilities.actionsGlobalContext().lookupResult(Person.class);
        this.results.addLookupListener((LookupListener)this);
    }

    protected void removeNotify() {
        super.removeNotify();
        LOG.info("PersonChildFactory REMOVE NOTIFY");
        if (this.results != null) {
            this.results.removeLookupListener((LookupListener)this);
        }
        this.results = null;
    }

    public void resultChanged(LookupEvent arg0) {
        SwingUtilities.invokeLater(() -> {
            TopComponent personList = WindowManager.getDefault().findTopComponent("PersonListTopComponent");
            if (personList != null) {
                LOG.info("person result changed");
                Person selectedPerson = ((PersonListTopComponent)personList).getSelectedPerson();
                if (selectedPerson != null) {
                    LOG.info("it's a person ... show pictures for " + selectedPerson.getName());
                    ArrayList<Person> persons = new ArrayList<Person>();
                    persons.add(selectedPerson);
                    ShowPicturesAction.getInstance().showAllPersonPictures(persons, true);
                }
                LOG.info("person result changed finished");
            }
        });
    }
}

