/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.person.action;

import com.querydsl.core.types.dsl.EntityPathBase;
import jakarta.persistence.RollbackException;
import java.awt.Image;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.openide.awt.NotificationDisplayer;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.PersonBody;
import xxx.scenerixx.scenerixxlib.model.PersonWebsites;
import xxx.scenerixx.scenerixxlib.model.QSceneDetails;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.SceneDetails;
import xxx.scenerixx.scenerixxlib.model.person.ChartPosition;
import xxx.scenerixx.scenerixxlib.model.person.QChartPosition;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.Statistic;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.person.PersonListTopComponent;

public class DeletePersonAction
extends NodeAction
implements Presenter.Popup {
    private final DB db = DB.getInstance();

    public DeletePersonAction() {
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
        Image image = ImageUtilities.loadImage((String)"icons/persons.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/remove.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        TopComponent personList;
        boolean reload = false;
        for (Node n : activatedNodes) {
            int resetAssignments;
            Object sd;
            Object object;
            if (n.getValue("person") == null || !((object = n.getValue("person")) instanceof Person)) continue;
            Person p = (Person)object;
            Person person = (Person)this.db.getEntityService().load(Person.class, p.getId().longValue());
            boolean rolledback = false;
            List personsAssignedToScene = this.db.getScenes(person, Scenerixx.unlocked);
            for (Scene scene : personsAssignedToScene) {
                sd = (SceneDetails)this.db.getEntityService().find((EntityPathBase)QSceneDetails.sceneDetails).filter(f -> f.person.eq((Object)person)).filter(f -> f.scene.eq((Object)scene)).findFirst();
                if (sd == null) continue;
                this.db.getEntityService().delete((AbstractEntity)sd);
            }
            try {
                Object fts2;
                Object pb;
                Statistic stat = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.person.eq((Object)person)).findFirst();
                if (stat != null) {
                    stat.setPerson(null);
                    this.db.getEntityService().delete((AbstractEntity)stat);
                }
                ArrayList personBodys = new ArrayList(person.getPersonBodys());
                sd = personBodys.iterator();
                while (sd.hasNext()) {
                    pb = (PersonBody)sd.next();
                    pb.setPerson(null);
                }
                person.getPersonBodys().clear();
                sd = personBodys.iterator();
                while (sd.hasNext()) {
                    pb = (PersonBody)sd.next();
                    this.db.getEntityService().delete((AbstractEntity)pb);
                }
                ArrayList favorites = new ArrayList(person.getFavorites());
                for (Object fts2 : favorites) {
                    fts2.setPerson(null);
                }
                person.getFavorites().clear();
                for (Object fts2 : favorites) {
                    this.db.getEntityService().delete((AbstractEntity)fts2);
                }
                ArrayList websites = new ArrayList(person.getPersonWebsites());
                for (PersonWebsites site : websites) {
                    site.setPerson(null);
                }
                person.getPersonWebsites().clear();
                fts2 = websites.iterator();
                while (fts2.hasNext()) {
                    PersonWebsites site;
                    site = (PersonWebsites)fts2.next();
                    this.db.getEntityService().delete((AbstractEntity)site);
                }
                List chartPositions = this.db.getEntityService().find((EntityPathBase)QChartPosition.chartPosition).filter(f -> f.person.eq((Object)person)).find();
                for (ChartPosition cp : chartPositions) {
                    cp.setPerson(null);
                    this.db.getEntityService().delete((AbstractEntity)cp);
                }
                if (this.db.getEntityService().delete((AbstractEntity)person)) {
                    AbstractTopComponent.notifyInfo("Deleted " + person.getName());
                    reload = true;
                } else {
                    rolledback = true;
                }
            }
            catch (RollbackException ex) {
                rolledback = true;
            }
            if (!rolledback || (resetAssignments = JOptionPane.showConfirmDialog(null, "Could not delete " + person.getName() + ". There's still an assignment.\nShould we try to reset all assignments and try again?", "Reset person assignments?", 0, 2)) != 0) continue;
            for (Scene s : personsAssignedToScene) {
                SceneDetails sd2 = (SceneDetails)this.db.getEntityService().find((EntityPathBase)QSceneDetails.sceneDetails).filter(f -> f.person.eq((Object)person)).filter(f -> f.scene.eq((Object)s)).findFirst();
                if (sd2 == null) continue;
                this.db.getEntityService().delete((AbstractEntity)sd2);
            }
            try {
                this.db.getEntityService().delete((AbstractEntity)person);
                AbstractTopComponent.notify("Deleted person '" + person.getName() + "'", ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
                reload = true;
            }
            catch (RollbackException ex) {
                JOptionPane.showMessageDialog(null, "Sorry, still no success. Seems like some manual labor needs to be done :-/", "Error", 0);
            }
        }
        if (reload && (personList = WindowManager.getDefault().findTopComponent("PersonListTopComponent")) != null) {
            ((PersonListTopComponent)personList).reloadList();
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Delete person(s)";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

