/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.person.action;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.exporter.Exporter;
import xxx.scenerixx.scenerixxlib.exporter.Importer;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.PersonBody;
import xxx.scenerixx.scenerixxlib.model.QPerson;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class ImportPersonAction
extends NodeAction {
    private static final Logger LOG = Logger.getLogger(ImportPersonAction.class.getName());
    private DB db = DB.getInstance();

    protected void performAction(Node[] activatedNodes) {
        int imported = 0;
        for (Node n : activatedNodes) {
            Object object;
            if (n.getValue("person") == null || !((object = n.getValue("person")) instanceof Person)) continue;
            Person person = (Person)object;
            try {
                Importer imp = new Importer();
                String pathToPersonImport = Scenerixx.getPathToPersonImport(person);
                LOG.info("Import path to person: " + pathToPersonImport);
                if (pathToPersonImport == null) {
                    JOptionPane.showMessageDialog(null, "An error occurred importing " + person.getName() + ". Aborted import.", "Error", 0);
                    return;
                }
                String personName = person.getName();
                String name = pathToPersonImport + Exporter.removeSpecialChars((String)(personName = personName.replaceAll("-", "_"))) + "_person.scenerixx";
                Person personToImport = imp.importPersonFile(name);
                if (personToImport == null) {
                    JOptionPane.showMessageDialog(null, "An error occurred importing " + name + ". Aborted import.", "Error", 0);
                    continue;
                }
                if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)personToImport.getName())).count() > 0L) {
                    JOptionPane.showMessageDialog(null, personToImport.getName() + " exists already. Aborted import.");
                    continue;
                }
                Person importedPerson = (Person)this.db.getEntityService().save((AbstractEntity)personToImport);
                for (PersonBody pb : personToImport.getPersonBodys()) {
                    pb.setPerson(importedPerson);
                    pb = (PersonBody)this.db.getEntityService().save((AbstractEntity)pb);
                }
                AbstractTopComponent.notifyInfo(personToImport.getName() + " was imported");
                ++imported;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("Could not import person. An error occured: " + ex.getMessage());
                LOG.severe("Could not import person. An error occured: " + ex.getMessage());
            }
        }
        AbstractTopComponent.dirtyPersonList();
        AbstractTopComponent.notifyInfo(imported + " persons have been imported");
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Import person(s)";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }
}

