/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.person.action;

import com.querydsl.core.types.dsl.EntityPathBase;
import jakarta.persistence.RollbackException;
import java.awt.Image;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.statistic.QStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.Statistic;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.person.PersonListTopComponent;

public class ResetICameCounterAction
extends NodeAction
implements Presenter.Popup {
    private final DB db = DB.getInstance();

    public ResetICameCounterAction() {
        Image image = ImageUtilities.loadImage((String)"icons2/Heart.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/remove.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        for (Node n : activatedNodes) {
            if (n.getValue("person") == null || !(n.getValue("person") instanceof Person)) continue;
            Person tmpPerson = (Person)n.getValue("person");
            Person person = (Person)this.db.getEntityService().load(Person.class, tmpPerson.getId().longValue());
            try {
                Statistic stat = (Statistic)this.db.getEntityService().find((EntityPathBase)QStatistic.statistic).filter(f -> f.person.eq((Object)person)).findFirst();
                if (stat != null) {
                    stat.getLikes().clear();
                    stat = (Statistic)this.db.getEntityService().save((AbstractEntity)stat);
                    AbstractTopComponent.notifyInfo("Resetted counter for " + person.getName());
                }
            }
            catch (RollbackException ex) {
                JOptionPane.showMessageDialog(null, "Could not reset counter for " + person.getName() + ".", "Error", 0);
            }
            TopComponent personList = WindowManager.getDefault().findTopComponent("PersonListTopComponent");
            if (personList == null) continue;
            ((PersonListTopComponent)personList).reloadList();
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        boolean result = false;
        for (Node n : activatedNodes) {
            if (n.getValue("person") == null || !(n.getValue("person") instanceof Person) || this.db.getIcameDirect((Person)n.getValue("person")) <= 0) continue;
            result = true;
            break;
        }
        return result;
    }

    public String getName() {
        return "Reset 'I came' counter";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

