/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.scene.action;

import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.PersonComboRenderer;

public class AddPersonsFromClipboardPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(AddPersonsFromClipboardPanel.class.getName());
    private List<JComboBox<Person>> comboBoxes = new ArrayList<JComboBox<Person>>();

    public AddPersonsFromClipboardPanel(List<Person> persons, String searchTerm, String delimiter) {
        super(new FlowLayout());
        LOG.info("searchTerm: " + searchTerm + " - delimiter: " + delimiter + " - persons size: " + persons.size());
        for (Person p : persons) {
            LOG.info("Passed in persons: " + p.getName());
        }
        HashMap map = new HashMap();
        for (String s : searchTerm.split(delimiter)) {
            s = s.toLowerCase().trim();
            for (Person p : persons) {
                if (!p.getName().toLowerCase().contains(s)) continue;
                if (map.containsKey(s)) {
                    LOG.info("Add to existing: " + p.getName());
                    ((List)map.get(s)).add(p);
                    continue;
                }
                ArrayList<Person> arrayList = new ArrayList<Person>();
                LOG.info("Add new: " + p.getName());
                arrayList.add(p);
                map.put(s, arrayList);
            }
        }
        for (String s : map.keySet()) {
            LOG.info("add : " + s);
            this.addRow((List)map.get(s));
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    private void addRow(List<Person> p) {
        LOG.info("add rows: " + p.size());
        JComboBox<Object> jComboBox = new JComboBox<Object>();
        Person[] toArray = (Person[])p.toArray(Person[]::new);
        jComboBox.setModel(new DefaultComboBoxModel<Person>(toArray));
        jComboBox.setRenderer(new PersonComboRenderer());
        if (jComboBox.getModel().getSize() == 1) {
            jComboBox.setEnabled(false);
            LOG.info("Disabled: " + ((Person)jComboBox.getModel().getElementAt(0)).getName());
        }
        jComboBox.setSelectedIndex(0);
        this.comboBoxes.add(jComboBox);
        this.add(jComboBox);
    }

    public List<JComboBox<Person>> getComboBoxes() {
        return this.comboBoxes;
    }
}

