/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.special;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.enums.BodyType;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.childfactories.person.PersonChildFactory;
import xxx.scenerixx.scenerixxmodule.util.gui.IconsUtil;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.playlist.PlaylistTopComponent;

public class BodyTypeChildFactory
extends ChildFactory<BodyType> {
    public static final Logger LOG = Logger.getLogger(BodyTypeChildFactory.class.getName());
    private List<BodyType> bodyTypeList;
    private DB db = DB.getInstance();
    private Gender gender = null;
    private boolean showCounter = false;
    private boolean showBirthyear = false;
    private boolean showRating = false;
    private boolean showLikeCounter = false;
    private boolean showRuntime = false;
    private boolean showSecret = false;
    private boolean showPosition = false;

    public BodyTypeChildFactory(Gender gender, boolean showCounter, boolean showBirthyear, boolean showRating, boolean showLikeCounter, boolean showRuntime, boolean showSecret, boolean showPosition) {
        this.bodyTypeList = new ArrayList<BodyType>(Arrays.asList(BodyType.values()));
        this.gender = gender;
        this.showCounter = showCounter;
        this.showBirthyear = showBirthyear;
        this.showRating = showRating;
        this.showLikeCounter = showLikeCounter;
        this.showRuntime = showRuntime;
        this.showSecret = showSecret;
        this.showPosition = showPosition;
        LOG.info("Gender: " + String.valueOf(gender));
    }

    public void reloadList(Node node) {
        LOG.finest("Hook method reloadList in BodyTypeChildFactory");
    }

    protected boolean createKeys(List<BodyType> list) {
        for (BodyType bodyType : this.bodyTypeList) {
            list.add(bodyType);
        }
        return true;
    }

    protected Node createNodeForKey(final BodyType bodyType) {
        LOG.finest("create new node for BodyType: " + bodyType.toString());
        List personsByBodyType = this.db.getPersonsByBodyType(this.gender, bodyType, this.showSecret);
        AbstractNode result = new AbstractNode(Children.create((ChildFactory)new PersonChildFactory(personsByBodyType, this.showCounter, this.showBirthyear, this.showRating, this.showLikeCounter, this.showRuntime, false, this.showPosition), (boolean)true)){

            public Image getOpenedIcon(int type) {
                if (BodyType.Skinny == bodyType) {
                    return ImageUtilities.loadImage((String)IconsUtil.ICON_BODYTYPE_SKINNY, (boolean)false);
                }
                if (BodyType.Slim == bodyType) {
                    return ImageUtilities.loadImage((String)IconsUtil.ICON_BODYTYPE_SLIM, (boolean)false);
                }
                if (BodyType.Petite == bodyType) {
                    return ImageUtilities.loadImage((String)IconsUtil.ICON_BODYTYPE_PETITE, (boolean)false);
                }
                if (BodyType.Athletic == bodyType) {
                    return ImageUtilities.loadImage((String)IconsUtil.ICON_BODYTYPE_ATHLETIC, (boolean)false);
                }
                if (BodyType.Normal == bodyType) {
                    return ImageUtilities.loadImage((String)IconsUtil.ICON_BODYTYPE_NORMAL, (boolean)false);
                }
                if (BodyType.Curvy == bodyType) {
                    return ImageUtilities.loadImage((String)IconsUtil.ICON_BODYTYPE_CURVY, (boolean)false);
                }
                if (BodyType.Chubby == bodyType) {
                    return ImageUtilities.loadImage((String)IconsUtil.ICON_BODYTYPE_CHUBBY, (boolean)false);
                }
                if (BodyType.BBW == bodyType) {
                    return ImageUtilities.loadImage((String)IconsUtil.ICON_BODYTYPE_BBW, (boolean)false);
                }
                if (BodyType.Fat == bodyType) {
                    return ImageUtilities.loadImage((String)IconsUtil.ICON_BODYTYPE_FAT, (boolean)false);
                }
                return ImageUtilities.loadImage((String)IconsUtil.ICON_BODYTYPE_NOTSET, (boolean)false);
            }

            public Image getIcon(int type) {
                return this.getOpenedIcon(type);
            }

            public Action[] getActions(boolean context) {
                ArrayList<CreatePlaylistAction> list = new ArrayList<CreatePlaylistAction>();
                list.add(new CreatePlaylistAction());
                Action[] actions = new Action[list.size()];
                actions = list.toArray(actions);
                return actions;
            }

            class CreatePlaylistAction
            extends AbstractAction {
                public CreatePlaylistAction() {
                    this.putValue("Name", "Create Playlist");
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    PlaylistService ps = new PlaylistService();
                    Playlist playlist = new Playlist();
                    playlist.setName(bodyType.getTitle());
                    playlist = (Playlist)BodyTypeChildFactory.this.db.getEntityService().save((AbstractEntity)playlist);
                    for (Person p : BodyTypeChildFactory.this.db.getPersonsByBodyType(BodyTypeChildFactory.this.gender, bodyType, Scenerixx.unlocked)) {
                        PlaylistEntry pe = new PlaylistEntry();
                        pe.setDateOfCreation(LocalDateTime.now());
                        pe.setPerson(p);
                        playlist = ps.addPlaylistEntry(pe, playlist, Scenerixx.unlocked);
                    }
                    TopComponent playlistList = WindowManager.getDefault().findTopComponent("PlaylistTopComponent");
                    if (playlistList != null) {
                        ((PlaylistTopComponent)playlistList).reloadList(playlist.getName());
                    }
                    Object message = "";
                    if (!playlist.getEntries(Scenerixx.unlocked).isEmpty()) {
                        message = "Created new playlist '" + playlist.getName() + "'";
                    } else {
                        BodyTypeChildFactory.this.db.getEntityService().delete((AbstractEntity)playlist);
                        message = "No person with this bodytype found. No playlist created.";
                    }
                    AbstractTopComponent.notifyInfo((String)message);
                }
            }
        };
        String app = " [" + this.db.getPersonsByBodyTypeCount(this.gender, bodyType, this.showSecret) + "]";
        result.setDisplayName(bodyType.getTitle() + app);
        result.setValue("bodytype", (Object)bodyType);
        result.setName(bodyType.getTitle());
        return result;
    }
}

