/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.studio.action;

import java.awt.Image;
import java.time.LocalDateTime;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.service.PlaylistService;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class CreatePlaylistAction
extends NodeAction
implements Presenter.Popup {
    private final DB db = DB.getInstance();

    public CreatePlaylistAction() {
        Image image = ImageUtilities.loadImage((String)"icons/notes.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"nbicons/badgeAdd.png"), (int)4, (int)4);
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        for (Node n : activatedNodes) {
            Object object;
            if (n.getValue("studio") == null || !((object = n.getValue("studio")) instanceof Studio)) continue;
            Studio studio = (Studio)object;
            studio = (Studio)this.db.getEntityService().load(Studio.class, studio.getId().longValue());
            PlaylistService ps = new PlaylistService();
            Playlist playlist = new Playlist();
            playlist.setName(studio.getName());
            int dvds = 0;
            for (Movie m : this.db.getMovies(studio, Scenerixx.unlocked)) {
                if (this.db.getDvd(m, Scenerixx.unlocked) == null) {
                    PlaylistEntry pe = new PlaylistEntry();
                    pe.setDateOfCreation(LocalDateTime.now());
                    pe.setMovie(m);
                    ps.addPlaylistEntry(pe, playlist, Scenerixx.unlocked);
                    continue;
                }
                ++dvds;
            }
            AbstractTopComponent.reloadPlaylist(studio.getName());
            String message = "Created new playlist '" + playlist.getName() + "'";
            if (dvds > 0) {
                message = message + " (" + dvds + " DVDs have not been added)";
            }
            AbstractTopComponent.notifyInfo(message);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes.length == 1;
    }

    public String getName() {
        return "Create Playlist";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

