/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.childfactories.studio.action;

import java.awt.Image;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.xml.transform.TransformerException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.exporter.Exporter;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class ExportStudioAction
extends NodeAction
implements Presenter.Popup {
    private static final Logger LOG = Logger.getLogger(ExportStudioAction.class.getName());

    public ExportStudioAction() {
        Image image = ImageUtilities.loadImage((String)"icons/Upload.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] activatedNodes) {
        for (Node n : activatedNodes) {
            Studio s;
            Object object;
            if (n.getValue("studio") == null || !((object = n.getValue("studio")) instanceof Studio) || (s = (Studio)object) == null) continue;
            Exporter e = new Exporter();
            String destinationFileName = e.getDestinationFileName(s, Scenerixx.scenerixxFilesExportDirBase + Scenerixx.scenerixxFilesDirStudio);
            boolean overwriteOption = false;
            if (new File(destinationFileName).exists()) {
                int overwrite = JOptionPane.showConfirmDialog(null, "A file with the name '" + destinationFileName + "' already exists. Do you want to overwrite it?\n'Yes' overwrites the file, 'No' uses a new filename, 'Cancel' aborts", "File exists already", 1, 2);
                if (overwrite == 0) {
                    overwriteOption = true;
                } else if (overwrite == 1) {
                    overwriteOption = false;
                } else if (overwrite == 2) {
                    AbstractTopComponent.notifyInfo("Aborted export. Existing file was not changed.");
                    return;
                }
            }
            String exportStudioToFile = "";
            try {
                exportStudioToFile = e.exportStudioToFile(s, Scenerixx.scenerixxFilesExportDirBase + Scenerixx.scenerixxFilesDirStudio, overwriteOption);
                AbstractTopComponent.notifyInfo(s.getName() + " exported to " + exportStudioToFile);
                LOG.info("Exported '" + s.getName() + "' to " + exportStudioToFile);
            }
            catch (TransformerException ex) {
                JOptionPane.showMessageDialog(null, "An error occured while exporting '" + s.getName() + "' to " + exportStudioToFile + ". Does the destination exists?\nThe error message we received: " + ex.getMessageAndLocation());
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Export Studio(s)";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }
}

