/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.util;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageResizer {
    private static final Logger LOG = LoggerFactory.getLogger(ImageResizer.class);

    public static ImageIcon rescaleImage(File source, int maxHeight, int maxWidth) {
        if (source == null || !source.exists()) {
            return new ImageIcon();
        }
        int newHeight = 0;
        int newWidth = 0;
        int priorHeight = 0;
        int priorWidth = 0;
        BufferedImage image = null;
        try {
            LOG.debug("Source of image to rescale: {}", (Object)source.getAbsolutePath());
            image = ImageIO.read(source);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (image == null) {
            return new ImageIcon();
        }
        ImageIcon sizeImage = new ImageIcon(image);
        if (sizeImage != null) {
            priorHeight = sizeImage.getIconHeight();
            priorWidth = sizeImage.getIconWidth();
        }
        if ((float)priorHeight / (float)priorWidth > (float)maxHeight / (float)maxWidth) {
            newHeight = maxHeight;
            newWidth = (int)((float)priorWidth / (float)priorHeight * (float)newHeight);
        } else {
            newWidth = maxWidth;
            newHeight = (int)((float)priorHeight / (float)priorWidth * (float)newWidth);
        }
        BufferedImage resizedImg = new BufferedImage(newWidth, newHeight, 1);
        Graphics2D g2 = resizedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(image, 0, 0, newWidth, newHeight, null);
        g2.dispose();
        LOG.info("rescale width/height: " + newWidth + " - " + newHeight);
        return new ImageIcon(resizedImg);
    }
}

