/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.util.gui;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoManager;

public class StandardContextMenu {
    private static final Logger LOG = Logger.getLogger(StandardContextMenu.class.getName());

    public static <T extends JTextComponent> void addTo(final T txtField) {
        JPopupMenu popup = new JPopupMenu();
        final UndoManager undoManager = new UndoManager();
        txtField.getDocument().addUndoableEditListener(undoManager);
        AbstractAction undoAction = new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (undoManager.canUndo()) {
                    undoManager.undo();
                } else {
                    LOG.finer("No Undo Buffer.");
                }
            }
        };
        AbstractAction copyAction = new AbstractAction("Copy"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                txtField.copy();
            }
        };
        AbstractAction cutAction = new AbstractAction("Cut"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                txtField.cut();
            }
        };
        AbstractAction pasteAction = new AbstractAction("Paste"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                txtField.paste();
            }
        };
        AbstractAction selectAllAction = new AbstractAction("Select All"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                txtField.selectAll();
            }
        };
        cutAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control X"));
        copyAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control C"));
        pasteAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control V"));
        selectAllAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("control A"));
        popup.add(undoAction);
        popup.addSeparator();
        popup.add(cutAction);
        popup.add(copyAction);
        popup.add(pasteAction);
        popup.addSeparator();
        popup.add(selectAllAction);
        txtField.setComponentPopupMenu(popup);
    }
}

