/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.util.gui.panel;

import com.github.lgooddatepicker.components.DateTimePicker;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;

public class FindDuplicatesPanel
extends JPanel {
    private String selectedPath;
    private JButton btnChoosePath;
    private JButton btnClearSelectedPath;
    private JButton btnReset;
    private JCheckBox cbStartWithLongestRuntime;
    private DateTimePicker dateTimePickerEnd;
    private DateTimePicker dateTimePickerStart;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel lbEndSecond;
    private JLabel lbEndSecondReadable;
    private JLabel lbIntro;
    private JLabel lbLastXDays;
    private JLabel lbResume;
    private JLabel lbScecondsDiff;
    private JLabel lbSelectedPath;
    private JLabel lbStartSecond;
    private JLabel lbStartSecondReadable;
    private JLabel lbThreshold;
    private JTextField tfEndSecond;
    private JTextField tfSecondsDiff;
    private JTextField tfStartSecond;
    private JTextField tfThreshold;

    public FindDuplicatesPanel() {
        this.initComponents();
        this.resetValues();
        this.dateTimePickerStart.datePicker.setSettings(ScenerixxCommon.getDatePickerSettings());
        this.dateTimePickerEnd.datePicker.setSettings(ScenerixxCommon.getDatePickerSettings());
        this.lbIntro.setText("<html>Finding duplicates<br><br>This feature has a reaaaaallly loooong runtime. Depending on the size of your collection and your CPU. My machine needed over 12 hours, so let's make sure you understand what's happening here.<br>The duplicate finder compares movies based on their screencaps (they need to have the same dimension). All movies with the same runtime are compared to each other. <br>If the differences are not too big (a diff value below 10.0) we consider it as a duplicate. A value of 0.0 indicates that they are identical.<br>Like this possible duplicates can be found that have a different resolution.<br>All possible duplicates are saved on a dedicated playlist that you can check later on.<br>You can define with which runtime (in seconds) the duplicate finder should start. This way you can always abort the process and continue it later on.<br>You should not specify a starting point below 60 seconds because that could cause a lot of false positives.<br><br>The threshold value defines how sensitive the duplicate finder should act. A sensible value is 10.0 which won't generate any false positives. <br>A value of above 25.0 will result in almost all false positives. I also had once a duplicate with a value of 17.2.<br>One user reported that he had a lot less false positives when he used screencaps with the dimension of 1900x1000, 3 cols, 4 rows.<br>If you want to play around with this value you can see the value for each comparision in the log.<br><br>Note: if you provide a time span only movies added during this time is considered. This is useful if you just want to check just added movies for duplicates.<br>If you checked today already for duplicates and added later on some movies and you want to check again you can even define a time range. <br>Like this you can check the movies you added 10 minutes ago but ignore the ones you added a few hours ago.<br></html>");
        DB db = DB.getInstance();
        ScenerixxSettings scenerixxSettings = db.getScenerixxSettings();
        if (scenerixxSettings.getDupFinderAbortDate() != null) {
            if (scenerixxSettings.getDupFinderStartWithLongest().booleanValue()) {
                this.tfEndSecond.setText("" + scenerixxSettings.getDupFinderCurrentSecond());
                this.tfStartSecond.setText("" + scenerixxSettings.getDupFinderStart());
            } else {
                this.tfEndSecond.setText("" + scenerixxSettings.getDupFinderEnd());
                this.tfStartSecond.setText("" + scenerixxSettings.getDupFinderCurrentSecond());
            }
            this.tfEndSecondKeyReleased(null);
            this.tfStartSecondKeyReleased(null);
            LocalDateTime start = Instant.ofEpochMilli(scenerixxSettings.getDupFinderDateStart().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
            LocalDateTime end = Instant.ofEpochMilli(scenerixxSettings.getDupFinderDateEnd().getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
            this.dateTimePickerStart.setDateTimePermissive(start);
            this.dateTimePickerEnd.setDateTimePermissive(end);
            this.tfSecondsDiff.setText("" + scenerixxSettings.getDupFinderDiffSeconds());
            this.tfThreshold.setText("" + scenerixxSettings.getDupFinderThreshold());
            this.cbStartWithLongestRuntime.setSelected(scenerixxSettings.getDupFinderStartWithLongest());
            this.toggleStartWithLongestRuntimeCheckbox();
            this.btnReset.setVisible(true);
            this.lbResume.setVisible(true);
        } else {
            this.btnReset.setVisible(false);
            this.lbResume.setVisible(false);
        }
    }

    private void toggleStartWithLongestRuntimeCheckbox() {
        if (this.cbStartWithLongestRuntime.isSelected()) {
            this.cbStartWithLongestRuntime.setIcon(new ImageIcon(this.getClass().getResource("/icons.fatcow/sort_descending.png")));
        } else {
            this.cbStartWithLongestRuntime.setIcon(null);
        }
    }

    public int getStartSecond() {
        int result = 60;
        try {
            result = Integer.parseInt(this.tfStartSecond.getText());
        }
        catch (NumberFormatException nfe) {
            result = 60;
        }
        return result;
    }

    public int getEndSecond() {
        int result = 36000;
        try {
            result = Integer.parseInt(this.tfEndSecond.getText());
        }
        catch (NumberFormatException nfe) {
            result = 36000;
        }
        return result;
    }

    public double getThresholdValue() {
        double result = 10.0;
        try {
            result = Double.parseDouble(this.tfThreshold.getText());
        }
        catch (NumberFormatException nfe) {
            result = 10.0;
        }
        return result;
    }

    public int getDiffSeconds() {
        int result = 0;
        try {
            result = Integer.parseInt(this.tfSecondsDiff.getText());
        }
        catch (NumberFormatException nfe) {
            result = 0;
        }
        return result;
    }

    public LocalDateTime getStartTime() {
        return this.dateTimePickerStart.getDateTimePermissive();
    }

    public LocalDateTime getEndTime() {
        return this.dateTimePickerEnd.getDateTimePermissive();
    }

    public boolean startWithLongestRuntime() {
        return this.cbStartWithLongestRuntime.isSelected();
    }

    private void initComponents() {
        this.lbIntro = new JLabel();
        this.tfStartSecond = new JTextField();
        this.lbStartSecond = new JLabel();
        this.lbThreshold = new JLabel();
        this.tfThreshold = new JTextField();
        this.lbScecondsDiff = new JLabel();
        this.tfSecondsDiff = new JTextField();
        this.lbLastXDays = new JLabel();
        this.lbEndSecond = new JLabel();
        this.tfEndSecond = new JTextField();
        this.cbStartWithLongestRuntime = new JCheckBox();
        this.lbResume = new JLabel();
        this.btnReset = new JButton();
        this.lbEndSecondReadable = new JLabel();
        this.lbStartSecondReadable = new JLabel();
        this.dateTimePickerStart = new DateTimePicker();
        this.dateTimePickerEnd = new DateTimePicker();
        this.jLabel1 = new JLabel();
        this.btnChoosePath = new JButton();
        this.lbSelectedPath = new JLabel();
        this.btnClearSelectedPath = new JButton();
        this.jLabel2 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.lbIntro, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.lbIntro.text"));
        this.tfStartSecond.setText(NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.tfStartSecond.text"));
        this.tfStartSecond.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FindDuplicatesPanel.this.tfStartSecondKeyReleased(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbStartSecond, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.lbStartSecond.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbThreshold, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.lbThreshold.text"));
        this.tfThreshold.setText(NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.tfThreshold.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbScecondsDiff, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.lbScecondsDiff.text"));
        this.tfSecondsDiff.setText(NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.tfSecondsDiff.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbLastXDays, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.lbLastXDays.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbEndSecond, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.lbEndSecond.text"));
        this.tfEndSecond.setText(NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.tfEndSecond.text"));
        this.tfEndSecond.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                FindDuplicatesPanel.this.tfEndSecondKeyReleased(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbStartWithLongestRuntime, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.cbStartWithLongestRuntime.text"));
        this.cbStartWithLongestRuntime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDuplicatesPanel.this.cbStartWithLongestRuntimeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbResume, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.lbResume.text"));
        this.btnReset.setIcon(new ImageIcon(this.getClass().getResource("/icons/Cancel.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReset, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.btnReset.text"));
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDuplicatesPanel.this.btnResetActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbEndSecondReadable, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.lbEndSecondReadable.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbStartSecondReadable, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.lbStartSecondReadable.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.jLabel1.text"));
        this.btnChoosePath.setIcon(new ImageIcon(this.getClass().getResource("/icons/Folder.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnChoosePath, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.btnChoosePath.text"));
        this.btnChoosePath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDuplicatesPanel.this.btnChoosePathActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbSelectedPath, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.lbSelectedPath.text"));
        this.btnClearSelectedPath.setIcon(new ImageIcon(this.getClass().getResource("/icons/Cancel.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnClearSelectedPath, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.btnClearSelectedPath.text"));
        this.btnClearSelectedPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindDuplicatesPanel.this.btnClearSelectedPathActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(FindDuplicatesPanel.class, (String)"FindDuplicatesPanel.jLabel2.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbIntro, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbThreshold).addComponent(this.lbScecondsDiff).addComponent(this.lbStartSecond).addComponent(this.lbLastXDays).addComponent(this.lbEndSecond)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.tfStartSecond, GroupLayout.Alignment.LEADING, -1, 86, Short.MAX_VALUE).addComponent(this.tfThreshold, GroupLayout.Alignment.LEADING).addComponent(this.tfSecondsDiff, GroupLayout.Alignment.LEADING).addComponent(this.tfEndSecond)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbEndSecondReadable).addComponent(this.lbStartSecondReadable))).addGroup(layout.createSequentialGroup().addComponent((Component)this.dateTimePickerStart, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.dateTimePickerEnd, -2, -1, -2)))).addComponent(this.cbStartWithLongestRuntime).addComponent(this.lbResume).addComponent(this.btnReset).addGroup(layout.createSequentialGroup().addComponent(this.btnChoosePath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnClearSelectedPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbSelectedPath)).addComponent(this.jLabel2, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lbIntro, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfStartSecond, -2, -1, -2).addComponent(this.lbStartSecond).addComponent(this.lbStartSecondReadable)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbEndSecond).addComponent(this.tfEndSecond, -2, -1, -2).addComponent(this.lbEndSecondReadable)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbThreshold).addComponent(this.tfThreshold, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbScecondsDiff).addComponent(this.tfSecondsDiff, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbLastXDays).addComponent((Component)this.dateTimePickerStart, -2, -1, -2).addComponent(this.jLabel1).addComponent((Component)this.dateTimePickerEnd, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbStartWithLongestRuntime).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnChoosePath).addComponent(this.lbSelectedPath).addComponent(this.btnClearSelectedPath)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbResume).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReset).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void btnResetActionPerformed(ActionEvent evt) {
        this.resetValues();
    }

    private void tfEndSecondKeyReleased(KeyEvent evt) {
        this.lbEndSecondReadable.setText(ScenerixxCommon.readableSecondsDuration((long)Integer.parseInt(this.tfEndSecond.getText()) + 0L));
    }

    private void tfStartSecondKeyReleased(KeyEvent evt) {
        this.lbStartSecondReadable.setText(ScenerixxCommon.readableSecondsDuration((long)Integer.parseInt(this.tfStartSecond.getText()) + 0L));
    }

    private void cbStartWithLongestRuntimeActionPerformed(ActionEvent evt) {
        this.toggleStartWithLongestRuntimeCheckbox();
    }

    private void btnChoosePathActionPerformed(ActionEvent evt) {
        this.selectPath();
    }

    private void btnClearSelectedPathActionPerformed(ActionEvent evt) {
        this.selectedPath = null;
        this.lbSelectedPath.setText("Currently no path selected. All movies will be taken into consideration");
    }

    private void selectPath() throws HeadlessException {
        JFileChooser jFileChooser2 = new JFileChooser();
        jFileChooser2.setFileSelectionMode(1);
        ScenerixxSettings scenerixxSettings = DB.getInstance().getScenerixxSettings();
        scenerixxSettings.getLastIndexDirectory();
        jFileChooser2.setCurrentDirectory(new File(scenerixxSettings.getLastIndexDirectory()));
        int ret = jFileChooser2.showOpenDialog(null);
        if (ret == 0) {
            this.selectedPath = jFileChooser2.getSelectedFile().getAbsolutePath();
            this.lbSelectedPath.setText("Selected path: " + this.selectedPath);
        }
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    private void resetValues() {
        this.btnReset.setVisible(false);
        this.lbResume.setVisible(false);
        this.tfStartSecond.setText("60");
        this.tfEndSecond.setText("36000");
        this.tfThreshold.setText("10.0");
        this.tfSecondsDiff.setText("0");
        this.dateTimePickerStart.setDateTimePermissive(null);
        this.dateTimePickerEnd.setDateTimePermissive(null);
        this.cbStartWithLongestRuntime.setSelected(false);
        this.tfEndSecondKeyReleased(null);
        this.tfStartSecondKeyReleased(null);
        this.selectedPath = null;
        this.lbSelectedPath.setText("Currently no path selected. All movies will be taken into consideration");
    }
}

