/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.util.sync;

import api.api.ScenerixxRestApiApi;
import api.model.BackendMovie;
import api.model.BackendPerson;
import api.model.BackendStudio;
import api.model.UploadHashesRequest;
import api.model.UploadMovieRequest;
import api.model.UploadPersonRequest;
import api.model.UploadStudioRequest;
import api.model.UploadUsageStatisticRequest;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.transform.TransformerException;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.springframework.web.client.RestClientException;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.exporter.ExportLevel;
import xxx.scenerixx.scenerixxlib.exporter.Exporter;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.settings.ScenerixxSettings;
import xxx.scenerixx.scenerixxlib.util.ScenerixxCommonLib;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.WebserviceUtil;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;

public class WebServiceHelper {
    private static final DB db = DB.getInstance();
    private static final ScenerixxSettings settings = db.getScenerixxSettings();
    private static final ScenerixxRestApiApi api = new ScenerixxRestApiApi();
    private static final Logger LOG = Logger.getLogger(WebServiceHelper.class.getName());

    public static Studio searchParentStudioOnServer(Long id) {
        Studio studio = null;
        Gson gson = ScenerixxCommonLib.getGsonBuilder().create();
        String studioString = api.getParentStudio(id);
        if (studioString != null && !"null".equalsIgnoreCase(studioString)) {
            studio = (Studio)gson.fromJson(studioString, Studio.class);
        }
        return studio;
    }

    public static List<Studio> searchStudioOnServer(String studioName) {
        return WebServiceHelper.searchStudioOnServer(studioName, true);
    }

    public static List<Studio> searchStudioOnServer(String studioName, boolean showMessage) {
        List studios = null;
        Gson gson = ScenerixxCommonLib.getGsonBuilder().create();
        String countStudioString = null;
        try {
            countStudioString = api.countStudio(studioName, Boolean.TRUE);
        }
        catch (RestClientException restClientException) {
            LOG.severe("Shoot. Error communicating with mother ship: " + restClientException.getMessage());
        }
        Long count = (Long)gson.fromJson(countStudioString, Long.class);
        if (count != null && showMessage) {
            if (count == 0L) {
                AbstractTopComponent.notifyInfo("No studio found!");
                return null;
            }
            if (count > 1L) {
                AbstractTopComponent.notifyInfo("Found " + count + " studios which match your search request. You see the first result. Refine your search if it's the wrong one.!");
            }
        }
        String studiosString = api.getStudios(studioName, Boolean.TRUE);
        LOG.info("studiostring: " + studiosString);
        if (studiosString != null && !"null".equalsIgnoreCase(studiosString)) {
            studios = (List)gson.fromJson(studiosString, new TypeToken<List<Studio>>(){}.getType());
            for (Studio s : studios) {
                String parentString = api.getParentStudio(s.getId());
                if (parentString != null && !parentString.isEmpty() && !parentString.equalsIgnoreCase("null")) {
                    LOG.info("Got a parent studio for " + s.getName() + ": " + parentString);
                    Studio parent = (Studio)gson.fromJson(parentString, new TypeToken<Studio>(){}.getType());
                    s.setParent(parent);
                    continue;
                }
                LOG.info("Got no parent studio for " + s.getName());
            }
        }
        return studios;
    }

    public static boolean uploadStudio(Studio studio) throws JsonSyntaxException {
        boolean result = true;
        ScenerixxSettings settings = db.getScenerixxSettings();
        LOG.fine("Upload studio: " + String.valueOf(studio));
        Studio toUpload = new Studio();
        toUpload.setHomepage(studio.getHomepage());
        toUpload.setHomepage2(studio.getHomepage2());
        toUpload.setName(studio.getName());
        toUpload.setOtherUrls(studio.getOtherUrls());
        toUpload.setYearFounded(studio.getYearFounded());
        toUpload.setYearDefunct(studio.getYearDefunct());
        toUpload.setStudioWebsites(studio.getStudioWebsites());
        Gson gson = ScenerixxCommonLib.getGsonBuilder().create();
        String toJson = gson.toJson((Object)toUpload);
        LOG.info("studio json: " + toJson);
        UploadStudioRequest usb = new UploadStudioRequest();
        usb.setToken(WebserviceUtil.getToken());
        usb.setStudioJson(toJson);
        BackendStudio uploadStudio = api.uploadStudio(settings.getExternalId(), usb);
        studio.setExternalId(uploadStudio.getId());
        LOG.fine("external id: " + studio.getExternalId());
        db.getEntityService().save((AbstractEntity)studio);
        return result;
    }

    public static List<Person> searchPersonOnServer(String personName) {
        String countPerson;
        List persons = null;
        Gson gson = ScenerixxCommonLib.getGsonBuilder().create();
        Long count = (Long)gson.fromJson(countPerson = api.countPerson(personName, Boolean.TRUE), Long.class);
        if (count != null) {
            if (count == 0L) {
                AbstractTopComponent.notifyInfo("No person found!");
                return null;
            }
            if (count > 1L) {
                AbstractTopComponent.notifyInfo("Found " + count + " persons which match your search request. You see the first result. Refine your search if it's the wrong one.!");
            }
        }
        String personString = api.getPersonVersions(personName, Boolean.TRUE);
        LOG.info("received person string: " + personString);
        if (personString != null && !"null".equalsIgnoreCase(personString)) {
            persons = (List)gson.fromJson(personString, new TypeToken<List<Person>>(){}.getType());
        }
        return persons;
    }

    public static List<Movie> searchMovieOnServer(String hash) {
        LOG.info("Searching movie on server: " + hash);
        List movies = null;
        Gson gson = ScenerixxCommonLib.getGsonBuilder().create();
        String countMovieString = api.countMovie(hash);
        Long count = (Long)gson.fromJson(countMovieString, Long.class);
        LOG.info("Found movies: " + count);
        if (count != null) {
            if (count == 0L) {
                AbstractTopComponent.notify("No movie found!", ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
                return null;
            }
            if (count > 1L) {
                AbstractTopComponent.notify("Found " + count + " movies which match your search request. You see the first result. Refine your search if it's the wrong one.!", ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "", null, NotificationDisplayer.Priority.LOW);
            }
        }
        String movieString = api.getMovieVersions(hash);
        LOG.info("GetMovieVersions: " + movieString);
        if (movieString != null && !"null".equalsIgnoreCase(movieString)) {
            movies = (List)gson.fromJson(movieString, new TypeToken<List<Movie>>(){}.getType());
        }
        return movies;
    }

    public static Person uploadPerson(Person currentPerson) throws JsonSyntaxException {
        ScenerixxSettings settings = db.getScenerixxSettings();
        LOG.fine("Upload person: " + String.valueOf(currentPerson));
        Gson gson = ScenerixxCommonLib.getGsonBuilder().create();
        Person toUpload = new Person();
        toUpload.setBirthDay(currentPerson.getBirthDay());
        toUpload.setBirthMonth(currentPerson.getBirthMonth());
        toUpload.setBirthYear(currentPerson.getBirthYear());
        toUpload.setCreditedAs(currentPerson.getCreditedAs());
        toUpload.setDickSize(currentPerson.getDickSize());
        toUpload.setDickSizeDifferentiator(currentPerson.getDickSizeDifferentiator());
        toUpload.setEthnicity(currentPerson.getEthnicity());
        toUpload.setGender(currentPerson.getGender());
        toUpload.setHairColor(currentPerson.getHairColor());
        toUpload.setIafd(currentPerson.getIafd());
        toUpload.setInstagram(currentPerson.getInstagram());
        toUpload.setName(currentPerson.getName());
        toUpload.setRealName(currentPerson.getRealName());
        toUpload.setNationality(currentPerson.getNationality());
        toUpload.setOfficialHomepage(currentPerson.getOfficialHomepage());
        toUpload.setOtherUrls(currentPerson.getOtherUrls());
        toUpload.setPersonBodys(currentPerson.getPersonBodys());
        toUpload.setPersonWebsites(currentPerson.getPersonWebsites());
        toUpload.setTwitter(currentPerson.getTwitter());
        toUpload.setWikipedia(currentPerson.getWikipedia());
        toUpload.setHeightInCm(currentPerson.getHeightInCm());
        toUpload.setPersonHeight(currentPerson.getPersonHeight());
        toUpload.setPersonHeightDifferentiator(currentPerson.getPersonHeightDifferentiator());
        toUpload.setCauseOfDeath(currentPerson.getCauseOfDeath());
        toUpload.setCauseOfDeathComment(currentPerson.getCauseOfDeathComment());
        toUpload.setDeathDay(currentPerson.getDeathDay());
        toUpload.setDeathMonth(currentPerson.getDeathMonth());
        toUpload.setDeathYear(currentPerson.getDeathYear());
        String toJson = gson.toJson((Object)toUpload);
        LOG.info("json" + toJson);
        UploadPersonRequest upb = new UploadPersonRequest();
        upb.setPersonJson(toJson);
        upb.setToken(WebserviceUtil.getToken());
        BackendPerson uploadedPerson = api.uploadPerson(settings.getExternalId(), upb);
        currentPerson.setExternalId(uploadedPerson.getId());
        currentPerson = (Person)db.getEntityService().save((AbstractEntity)currentPerson);
        LOG.info("External ID " + currentPerson.getExternalId() + " for person " + currentPerson.getName());
        return currentPerson;
    }

    public static boolean uploadMovieNew(Movie currentMovie) throws JsonSyntaxException {
        ScenerixxSettings settings = db.getScenerixxSettings();
        LOG.info("Upload movie new: " + currentMovie.getTitle() + " with " + currentMovie.getScenes().size() + " scenes!");
        String exportMovieToFilePath = "";
        Exporter exp = new Exporter();
        try {
            exportMovieToFilePath = exp.exportMovieToFile(currentMovie, System.getProperty("user.home") + File.separator + "scenerixx" + File.separator + Scenerixx.scenerixxTempDir, ExportLevel.Level_0);
            LOG.info("exportMovieToFilePath: " + exportMovieToFilePath);
        }
        catch (TransformerException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        Path path = Path.of(exportMovieToFilePath, new String[0]);
        LOG.info("path: " + String.valueOf(path));
        String uploadMovieScenerixxFile = "";
        try {
            uploadMovieScenerixxFile = Files.readString(path);
            LOG.info("uploadMovieScenerixxFile: " + uploadMovieScenerixxFile);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        UploadMovieRequest umb = new UploadMovieRequest();
        umb.setHash(currentMovie.getStartMedium().getHashValue());
        umb.setToken(WebserviceUtil.getToken());
        umb.setMovieJson(uploadMovieScenerixxFile);
        if (umb.getToken() == null) {
            LOG.info("no token found. abort");
            return false;
        }
        BackendMovie uploadMovie = api.uploadMovie(settings.getExternalId(), umb);
        currentMovie = (Movie)db.getEntityService().load(Movie.class, currentMovie.getId().longValue());
        currentMovie.setExternalId(uploadMovie.getId());
        LOG.fine("external id: " + currentMovie.getExternalId());
        currentMovie = (Movie)db.getEntityService().save((AbstractEntity)currentMovie);
        return true;
    }

    public static boolean uploadHashes(List<String> hashes) throws JsonSyntaxException {
        boolean result = false;
        LOG.fine("Upload hashes: " + hashes.size());
        UploadHashesRequest uhb = new UploadHashesRequest();
        uhb.setToken(WebserviceUtil.getToken());
        uhb.setHashes(hashes);
        api.uploadHashes(settings.getExternalId(), uhb);
        return result;
    }

    public static boolean uploadUsageStatistic(String stat) {
        UploadUsageStatisticRequest uusr = new UploadUsageStatisticRequest();
        uusr.setUsageStatistic(stat);
        api.uploadUsageStatistic(uusr);
        return true;
    }
}

