/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.time.LocalDateTime;
import java.util.logging.Logger;
import org.openide.LifecycleManager;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.statistic.QScenerixxStatistic;
import xxx.scenerixx.scenerixxlib.model.statistic.ScenerixxStatistic;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.upgrade.Upgrader;

public class Installer
implements Runnable {
    private static final Logger LOG = Logger.getLogger(Installer.class.getName());
    private DB db = DB.getInstance();

    @Override
    public void run() {
        LOG.info("Run Installer");
        ScenerixxStatistic scenerixxStat = (ScenerixxStatistic)this.db.getEntityService().find((EntityPathBase)QScenerixxStatistic.scenerixxStatistic).findFirst();
        if (scenerixxStat == null) {
            scenerixxStat = new ScenerixxStatistic();
            scenerixxStat.setCodename(Scenerixx.CODENAME);
            scenerixxStat.setVersion(Scenerixx.VERSION);
            scenerixxStat.getStarted().add(LocalDateTime.now());
            this.db.getEntityService().save((AbstractEntity)scenerixxStat);
            Scenerixx.firstRun = true;
        } else {
            LOG.info("Running Scenerixx version " + scenerixxStat.getVersion());
            if (!Scenerixx.VERSION.equals(scenerixxStat.getVersion())) {
                String oldVersion = scenerixxStat.getVersion();
                scenerixxStat.setCodename(Scenerixx.CODENAME);
                scenerixxStat.setVersion(Scenerixx.VERSION);
                scenerixxStat.getStarted().add(LocalDateTime.now());
                this.db.getEntityService().save((AbstractEntity)scenerixxStat);
                Upgrader upgrader = new Upgrader();
                upgrader.moveDirectories();
                int updatedRows = upgrader.upgradeData();
                if (updatedRows > 0) {
                    LOG.info("Upgraded data: " + updatedRows + " rows");
                    LOG.info("RESTARTING so changes take effect");
                    LifecycleManager.getDefault().markForRestart();
                    LifecycleManager.getDefault().exit();
                } else {
                    Scenerixx.upgradedToNewVersion = true;
                    LOG.info("Updated from version " + oldVersion);
                }
            } else {
                scenerixxStat.getStarted().add(LocalDateTime.now());
                scenerixxStat = (ScenerixxStatistic)this.db.getEntityService().save((AbstractEntity)scenerixxStat);
            }
        }
    }
}

