/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.movie;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.text.diff.CommandVisitor;
import org.apache.commons.text.diff.StringsComparator;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.exporter.Exporter;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.util.ScenerixxCommonLib;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.util.sync.WebServiceHelper;
import xxx.scenerixx.scenerixxmodule.windows.indexing.IndexingTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;

public class MovieDiffPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger(MovieDiffPanel.class.getName());
    private DetailsTopComponent panel;
    private List<Movie> movieServer;
    private Movie currentMovie;
    private int currentIndex = 0;
    private FileCommandsVisitor fileCommandsVisitor;
    private boolean showWhenNoDiff = true;
    private DiffView diffView;
    private JButton btnAbort;
    private JButton btnKeepCurrentAndDoNothing;
    private JButton btnKeepCurrentAndUpload;
    private JButton btnNext;
    private JButton btnPrev;
    private JButton btnUseVersionFromServer;
    private JPanel diffPanel;
    private JScrollPane jScrollPane1;
    private JLabel lbExplanation;

    public MovieDiffPanel() {
        this.initComponents();
    }

    public MovieDiffPanel(DetailsTopComponent panel, Movie currentMovie, List<Movie> movieOnServer, boolean showWhenNoDiff) {
        this();
        this.panel = panel;
        this.movieServer = movieOnServer;
        for (Scene s : currentMovie.getScenes()) {
            s.getDetails().sort((o1, o2) -> o1.compareTo(o2));
        }
        this.currentMovie = currentMovie;
        this.showWhenNoDiff = showWhenNoDiff;
        this.loadDiff(currentMovie);
        this.toggleButtonsEnabled();
    }

    public boolean isDiff() {
        return this.fileCommandsVisitor.isChanges();
    }

    private void loadDiff(Movie currentMovie) {
        this.movieServer.get(0).setId(currentMovie.getId());
        if (currentMovie.getStudio() != null) {
            LOG.info("Studio equals: " + currentMovie.getStudio().equals((Object)this.movieServer.get(0).getStudio()));
            LOG.info("Studio IDs: " + currentMovie.getStudio().getId() + " - " + this.movieServer.get(0).getStudio().getId());
        } else {
            LOG.info("no studio was set");
        }
        for (Scene s : currentMovie.getScenes()) {
            for (Person p : s.getPersons(Scenerixx.unlocked)) {
                try {
                    LOG.info("Person equals: " + p.equals(((Scene)this.movieServer.get(0).getScenes().get(0)).getPersons(true).get(0)));
                    LOG.info("Person IDs: " + p.getId() + " - " + ((Person)((Scene)this.movieServer.get(0).getScenes().get(0)).getPersons(true).get(0)).getId());
                }
                catch (Exception exception) {}
            }
        }
        LOG.info("Movie equals: " + currentMovie.equals(this.movieServer.get(0)));
        LOG.info("Movie IDs: " + currentMovie.getId() + " " + this.movieServer.get(0).getId());
        this.loadDiffOld(currentMovie);
        this.loadDiffNew(currentMovie);
    }

    private boolean loadDiffNew(Movie currentMovie) {
        String orgFileName = "";
        String newFileName = "";
        try {
            Exporter exp = new Exporter();
            orgFileName = exp.exportMovieToFile(currentMovie, System.getProperty("java.io.tmpdir"), ScenerixxCommonLib.determineExportLevel((Movie)currentMovie, (boolean)false));
            File f = new File(orgFileName);
            orgFileName = orgFileName.replace(".scenerixx", ".scenerixx.old");
            f.renameTo(new File(orgFileName));
            f = new File(orgFileName);
            Movie movieToExport = this.movieServer.get(this.currentIndex);
            movieToExport.setId(currentMovie.getId());
            LOG.info("IDDDDDDDDDDDDDDDD: " + movieToExport.getId());
            newFileName = exp.exportMovieToFile(movieToExport, System.getProperty("java.io.tmpdir"), ScenerixxCommonLib.determineExportLevel((Movie)currentMovie, (boolean)false));
            File f2 = new File(newFileName);
            newFileName = newFileName.replace(".scenerixx", ".scenerixx.new");
            f2.renameTo(new File(newFileName));
            f2 = new File(newFileName);
            File tmpf1 = new File(orgFileName);
            File tmpf2 = new File(newFileName);
            SwingUtilities.invokeLater(() -> {
                try {
                    LOG.info("starting new diff");
                    this.diffView = Diff.getDefault().createDiff(StreamSource.createSource((String)"name1", (String)("current version for " + currentMovie.getNameOfPlayable()), (String)"text/html", (File)tmpf1), StreamSource.createSource((String)"name2", (String)("version " + (this.currentIndex + 1) + " of " + this.movieServer.size() + " on server"), (String)"text/html", (File)tmpf2));
                    LOG.fine("diff count: " + this.diffView.getDifferenceCount() + " for " + currentMovie.getNameOfPlayable());
                    this.toggleButtonsEnabled();
                    Component component1 = this.diffView.getComponent();
                    LOG.info("component: " + String.valueOf(this.diffView.getComponent()));
                    component1.setSize(1150, 650);
                    this.diffPanel.add(component1);
                    this.revalidate();
                    LOG.fine(" new diff done... count: " + this.diffView.getDifferenceCount());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return this.isDiff();
    }

    private boolean loadDiffOld(Movie currentMovie) {
        String orgFileName = "";
        String newFileName = "";
        try {
            Exporter exp = new Exporter();
            orgFileName = exp.exportMovieToFile(currentMovie, System.getProperty("java.io.tmpdir"), ScenerixxCommonLib.determineExportLevel((Movie)currentMovie, (boolean)false));
            File f = new File(orgFileName);
            orgFileName = orgFileName.replace(".scenerixx", ".scenerixx.old");
            f.renameTo(new File(orgFileName));
            f = new File(orgFileName);
            newFileName = exp.exportMovieToFile(this.movieServer.get(this.currentIndex), System.getProperty("java.io.tmpdir"), ScenerixxCommonLib.determineExportLevel((Movie)currentMovie, (boolean)false));
            File f2 = new File(newFileName);
            newFileName = newFileName.replace(".scenerixx", ".scenerixx.new");
            f2.renameTo(new File(newFileName));
            f2 = new File(newFileName);
            LineIterator file1 = FileUtils.lineIterator((File)f, (String)"utf-8");
            LineIterator file2 = FileUtils.lineIterator((File)f2, (String)"utf-8");
            this.fileCommandsVisitor = new FileCommandsVisitor();
            while (file1.hasNext() || file2.hasNext()) {
                String right;
                String left = (file1.hasNext() ? file1.nextLine() : "") + "\n";
                StringsComparator comparator = new StringsComparator(left, right = (file2.hasNext() ? file2.nextLine() : "") + "\n");
                if ((double)comparator.getScript().getLCSLength() > (double)Integer.max(left.length(), right.length()) * 0.4) {
                    comparator.getScript().visit((CommandVisitor)this.fileCommandsVisitor);
                    continue;
                }
                StringsComparator leftComparator = new StringsComparator(left, "\n");
                leftComparator.getScript().visit((CommandVisitor)this.fileCommandsVisitor);
                StringsComparator rightComparator = new StringsComparator("\n", right);
                rightComparator.getScript().visit((CommandVisitor)this.fileCommandsVisitor);
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return this.fileCommandsVisitor.isChanges();
    }

    private void initComponents() {
        this.btnKeepCurrentAndUpload = new JButton();
        this.btnUseVersionFromServer = new JButton();
        this.btnNext = new JButton();
        this.btnPrev = new JButton();
        this.btnKeepCurrentAndDoNothing = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.diffPanel = new JPanel();
        this.btnAbort = new JButton();
        this.lbExplanation = new JLabel();
        this.btnKeepCurrentAndUpload.setIcon(new ImageIcon(this.getClass().getResource("/icons/Raise.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnKeepCurrentAndUpload, (String)NbBundle.getMessage(MovieDiffPanel.class, (String)"MovieDiffPanel.btnKeepCurrentAndUpload.text"));
        this.btnKeepCurrentAndUpload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieDiffPanel.this.btnKeepCurrentAndUploadActionPerformed(evt);
            }
        });
        this.btnUseVersionFromServer.setIcon(new ImageIcon(this.getClass().getResource("/icons/Fall.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnUseVersionFromServer, (String)NbBundle.getMessage(MovieDiffPanel.class, (String)"MovieDiffPanel.btnUseVersionFromServer.text"));
        this.btnUseVersionFromServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieDiffPanel.this.btnUseVersionFromServerActionPerformed(evt);
            }
        });
        this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/icons/Forward.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNext, (String)NbBundle.getMessage(MovieDiffPanel.class, (String)"MovieDiffPanel.btnNext.text"));
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieDiffPanel.this.btnNextActionPerformed(evt);
            }
        });
        this.btnPrev.setIcon(new ImageIcon(this.getClass().getResource("/icons/Back.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnPrev, (String)NbBundle.getMessage(MovieDiffPanel.class, (String)"MovieDiffPanel.btnPrev.text"));
        this.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieDiffPanel.this.btnPrevActionPerformed(evt);
            }
        });
        this.btnKeepCurrentAndDoNothing.setIcon(new ImageIcon(this.getClass().getResource("/icons/No.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnKeepCurrentAndDoNothing, (String)NbBundle.getMessage(MovieDiffPanel.class, (String)"MovieDiffPanel.btnKeepCurrentAndDoNothing.text"));
        this.btnKeepCurrentAndDoNothing.setToolTipText(NbBundle.getMessage(MovieDiffPanel.class, (String)"MovieDiffPanel.btnKeepCurrentAndDoNothing.toolTipText"));
        this.btnKeepCurrentAndDoNothing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieDiffPanel.this.btnKeepCurrentAndDoNothingActionPerformed(evt);
            }
        });
        this.diffPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MovieDiffPanel.this.diffPanelComponentResized(evt);
            }
        });
        GroupLayout diffPanelLayout = new GroupLayout(this.diffPanel);
        this.diffPanel.setLayout(diffPanelLayout);
        diffPanelLayout.setHorizontalGroup(diffPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        diffPanelLayout.setVerticalGroup(diffPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 559, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.diffPanel);
        this.btnAbort.setIcon(new ImageIcon(this.getClass().getResource("/icons/Cancel.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAbort, (String)NbBundle.getMessage(MovieDiffPanel.class, (String)"MovieDiffPanel.btnAbort.text"));
        this.btnAbort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MovieDiffPanel.this.btnAbortActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbExplanation, (String)NbBundle.getMessage(MovieDiffPanel.class, (String)"MovieDiffPanel.lbExplanation.text"));
        this.lbExplanation.setVerticalAlignment(1);
        this.lbExplanation.setVerticalTextPosition(1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.btnUseVersionFromServer, -1, -1, Short.MAX_VALUE).addComponent(this.btnKeepCurrentAndUpload, -1, -1, Short.MAX_VALUE).addComponent(this.btnKeepCurrentAndDoNothing, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.btnPrev).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnNext).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAbort))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbExplanation)).addComponent(this.jScrollPane1, -1, 1200, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnKeepCurrentAndDoNothing).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnKeepCurrentAndUpload).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnUseVersionFromServer).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnPrev, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnNext).addComponent(this.btnAbort))).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addComponent(this.lbExplanation))).addContainerGap()));
    }

    private void btnKeepCurrentAndUploadActionPerformed(ActionEvent evt) {
        WebServiceHelper.uploadMovieNew(this.currentMovie);
        this.closePanel();
    }

    private void closePanel() {
        JDialog parent = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, this);
        if (parent != null) {
            LOG.finer("dispose movie diff");
            parent.dispose();
        } else {
            LOG.finer("Movie parent is null");
        }
    }

    private void btnUseVersionFromServerActionPerformed(ActionEvent evt) {
        this.saveVersionFromServer();
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        this.showNextVersion();
    }

    private void btnPrevActionPerformed(ActionEvent evt) {
        this.showPrevVersion();
    }

    private void btnKeepCurrentAndDoNothingActionPerformed(ActionEvent evt) {
        this.closePanel();
    }

    private void btnAbortActionPerformed(ActionEvent evt) {
        this.abort();
    }

    private void diffPanelComponentResized(ComponentEvent evt) {
        this.resize();
    }

    private void resize() {
        this.diffView.getComponent().setSize(this.getSize());
    }

    private void abort() {
        IndexingTopComponent.abortIndexing = true;
        this.closePanel();
    }

    private void showNextVersion() {
        if (this.currentIndex < this.movieServer.size() - 1) {
            ++this.currentIndex;
            this.toggleButtonsEnabled();
            this.loadDiff(this.currentMovie);
        }
    }

    private void showPrevVersion() {
        if (this.currentIndex > 0) {
            --this.currentIndex;
            this.toggleButtonsEnabled();
            this.loadDiff(this.currentMovie);
        }
    }

    private void toggleButtonsEnabled() {
        LOG.finer("cur index " + this.currentIndex);
        if (this.currentIndex < this.movieServer.size() - 1) {
            this.btnNext.setEnabled(true);
        } else {
            this.btnNext.setEnabled(false);
        }
        if (this.currentIndex == 0) {
            this.btnPrev.setEnabled(false);
        } else {
            this.btnPrev.setEnabled(true);
        }
        if (!this.isDiff()) {
            this.btnKeepCurrentAndUpload.setEnabled(false);
            this.btnUseVersionFromServer.setEnabled(false);
            this.btnKeepCurrentAndUpload.setToolTipText("There are no differences.");
            this.btnUseVersionFromServer.setToolTipText("There are no differences.");
            if (!(this.showWhenNoDiff || this.btnPrev.isEnabled() || this.btnNext.isEnabled())) {
                LOG.info("trying to close");
                this.closePanel();
            }
        } else {
            this.btnKeepCurrentAndUpload.setEnabled(true);
            this.btnUseVersionFromServer.setEnabled(true);
            this.btnKeepCurrentAndUpload.setToolTipText("");
            this.btnUseVersionFromServer.setToolTipText("");
        }
    }

    public void saveVersionFromServer() {
        Movie movieToSave = this.movieServer.get(this.currentIndex);
        movieToSave.setId(this.currentMovie.getId());
        movieToSave.setExternalId(this.currentMovie.getExternalId());
        movieToSave = (Movie)DB.getInstance().getEntityService().save((AbstractEntity)movieToSave);
        this.panel.loadMovie(movieToSave);
        this.panel.saveChanges();
        this.closePanel();
    }

    class FileCommandsVisitor
    implements CommandVisitor<Character> {
        private static final String DELETION = "<span style=\"background-color: #FB504B\">${text}</span>";
        private static final String INSERTION = "<span style=\"background-color: #45EA85\">${text}</span>";
        private String left = "";
        private String right = "";
        private boolean changes = false;

        FileCommandsVisitor() {
        }

        public boolean isChanges() {
            return this.changes;
        }

        public void visitKeepCommand(Character c) {
            Object toAppend = "\n".equals("" + c) ? "<br/>" : "" + c;
            this.left = this.left + (String)toAppend;
            this.right = this.right + (String)toAppend;
        }

        public void visitInsertCommand(Character c) {
            Object toAppend = "\n".equals("" + c) ? "<br/>" : "" + c;
            this.right = this.right + INSERTION.replace("${text}", (String)toAppend);
            this.changes = true;
        }

        public void visitDeleteCommand(Character c) {
            Object toAppend = "\n".equals("" + c) ? "<br/>" : "" + c;
            this.left = this.left + DELETION.replace("${text}", (String)toAppend);
            this.changes = true;
        }

        public String generateHTML() throws IOException {
            this.left = this.left.replaceAll("<", "&lt;");
            this.left = this.left.replaceAll(">", "&gt;");
            this.left = this.left.replaceAll("&lt;br/&gt;", "<br>");
            this.left = this.left.replaceAll("&lt;/span&gt;", "</span>");
            this.left = this.left.replaceAll("&lt;span", "<span");
            this.left = this.left.replaceAll("\"&gt;", "\">");
            this.right = this.right.replaceAll("<", "&lt;");
            this.right = this.right.replaceAll(">", "&gt;");
            this.right = this.right.replaceAll("&lt;br/&gt;", "<br>");
            this.right = this.right.replaceAll("&lt;/span&gt;", "</span>");
            this.right = this.right.replaceAll("&lt;span", "<span");
            this.right = this.right.replaceAll("\"&gt;", "\">");
            return "<html><table><tr><tr><td><b>Current movie</b></td><td><b>Movie on server (" + (MovieDiffPanel.this.currentIndex + 1) + " of " + MovieDiffPanel.this.movieServer.size() + ")</b></td></tr><td><pre>" + this.left + "</pre></td><td><pre>" + this.right + "</pre></td></tr></table></html>";
        }
    }
}

