/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.person;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import xxx.scenerixx.scenerixxmodule.windows.person.PersonDetailsPanel;

public class FireworkParticle {
    private static final int radius = 5;
    private final double oneX;
    private final double oneY;
    private double vel = PersonDetailsPanel.getRandomIntegerInRange(4, 7);
    private double posR;
    private boolean exploding = false;
    private String colorHex;
    private List<Splash> splashes = new ArrayList<Splash>();

    public FireworkParticle(String colorHex) {
        int mouseX = PersonDetailsPanel.getRandomIntegerInRange(-250, 250);
        int mouseY = PersonDetailsPanel.getRandomIntegerInRange(0, 600);
        double mouseR = Math.hypot(mouseX, mouseY);
        this.oneX = 1.0 / mouseR * (double)mouseX;
        this.oneY = 1.0 / mouseR * (double)mouseY;
        this.posR = 25.0;
        this.colorHex = colorHex;
    }

    public void update() {
        if (this.exploding) {
            for (Splash s : this.splashes) {
                s.update();
            }
        } else if (this.vel <= 1.0) {
            this.exploding = true;
            int denom = PersonDetailsPanel.getRandomIntegerInRange(5, 10);
            for (int i = 0; i < 360; i += 22) {
                this.splashes.add(new Splash(this, i, 5.0 / (double)denom, this.colorHex));
            }
        } else {
            this.vel -= 0.05;
            this.posR += this.vel;
        }
    }

    public void draw(Graphics2D g) {
        if (this.exploding) {
            g.translate((int)(this.posR * this.oneX), (int)(this.posR * this.oneY));
            for (Splash s : this.splashes) {
                s.draw(g);
            }
            g.translate(-((int)(this.posR * this.oneX)), -((int)(this.posR * this.oneY)));
        } else {
            g.setColor(Color.decode(this.colorHex));
            g.fillOval((int)(this.posR * this.oneX - 5.0), (int)(this.posR * this.oneY - 5.0), 10, 10);
        }
    }

    public boolean isDead() {
        return this.exploding && !this.splashes.isEmpty() && this.splashes.get(0).isAtMaxDistance();
    }

    class Splash {
        private static final int radius = 2;
        private int maxR = PersonDetailsPanel.getRandomIntegerInRange(20, 80);
        private double curR = 0.0;
        private double vel;
        private int degree;
        private String colorHex;

        public Splash(FireworkParticle this$0, int degree, double vel, String colorHex) {
            this.degree = degree;
            this.vel = vel;
            this.colorHex = colorHex;
        }

        public void update() {
            this.curR = Math.min((double)this.maxR, this.curR + this.vel);
        }

        public boolean isAtMaxDistance() {
            return this.curR >= (double)this.maxR;
        }

        public void draw(Graphics2D g) {
            if (!this.isAtMaxDistance()) {
                g.setColor(Color.decode(this.colorHex));
                g.fillOval((int)(Math.cos(Math.toRadians(this.degree)) * this.curR) - 2, (int)(Math.sin(Math.toRadians(this.degree)) * this.curR) - 2, 4, 4);
            }
        }
    }
}

