/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.person;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.openide.awt.Mnemonics;
import org.openide.awt.NotificationDisplayer;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.comparator.PersonComparator;
import xxx.scenerixx.scenerixxlib.exporter.Importer;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.QPerson;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.enums.Appearance;
import xxx.scenerixx.scenerixxlib.model.enums.BodyPart;
import xxx.scenerixx.scenerixxlib.model.enums.BodyPartSize;
import xxx.scenerixx.scenerixxlib.model.enums.BodyType;
import xxx.scenerixx.scenerixxlib.model.enums.Ethnicity;
import xxx.scenerixx.scenerixxlib.model.enums.Gender;
import xxx.scenerixx.scenerixxlib.model.enums.HairColor;
import xxx.scenerixx.scenerixxlib.model.enums.Tab;
import xxx.scenerixx.scenerixxlib.model.enums.gui.OrderByGender;
import xxx.scenerixx.scenerixxlib.model.enums.gui.OrderByPerson;
import xxx.scenerixx.scenerixxlib.model.enums.gui.ShowHidePersonFilter;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.model.search.QSearchQuery;
import xxx.scenerixx.scenerixxlib.model.search.SearchQuery;
import xxx.scenerixx.scenerixxlib.model.settings.QUiState;
import xxx.scenerixx.scenerixxlib.model.settings.UiState;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.actions.ShowPicturesAction;
import xxx.scenerixx.scenerixxmodule.childfactories.person.PersonChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.person.action.DeletePersonAction;
import xxx.scenerixx.scenerixxmodule.childfactories.special.AppearanceChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.special.BodyPartSizeChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.special.BodyTypeChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.special.EthnicityChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.special.HairColorChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.special.NationalityChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.special.RemindsMeOfChildFactory;
import xxx.scenerixx.scenerixxmodule.util.Autocompleter;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.util.gui.StandardContextMenu;
import xxx.scenerixx.scenerixxmodule.util.gui.bean.ScenerixxBeanTreeView;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.OrderByGenderComboRenderer;
import xxx.scenerixx.scenerixxmodule.util.gui.renderer.OrderByPersonComboRenderer;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.dashboard.DashboardTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.DetailsTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.person.Bundle;
import xxx.scenerixx.scenerixxmodule.windows.person.action.ExportAllPersonsAction;
import xxx.scenerixx.scenerixxmodule.windows.person.action.ImportPersonAction;
import xxx.scenerixx.scenerixxmodule.windows.person.action.ReloadPersonsAction;
import xxx.scenerixx.scenerixxmodule.windows.person.action.ShowAvailableScenerixxFilesAction;
import xxx.scenerixx.scenerixxmodule.windows.person.action.ShowOnlyPersonsWithoutScenerixxFileAction;

@TopComponent.Description(preferredID="PersonListTopComponent", iconBase="icons/persons.png", persistenceType=0)
public final class PersonListTopComponent
extends AbstractTopComponent
implements ExplorerManager.Provider {
    public static final Logger LOG = Logger.getLogger(PersonListTopComponent.class.getName());
    private static final ExplorerManager em = new ExplorerManager();
    private boolean initialized = false;
    boolean showBirthyear = false;
    boolean showRuntime = false;
    boolean showRating = false;
    boolean showICame = false;
    private boolean asc = true;
    private boolean showScenerixxFiles = false;
    private Autocompleter autocompleter = new Autocompleter(25, true);
    private final ScenerixxCommon scenerixxCommon = new ScenerixxCommon();
    private BeanTreeView beanTreeView1;
    private JButton btnAddToDefaultPlaylist;
    private JButton btnCreatePlaylist;
    private JButton btnImportSelected;
    private JButton btnOpen;
    private JButton btnOpenRandomized;
    private JButton btnReload;
    private JButton btnReset;
    private JButton btnSelectRandomNode;
    private JToggleButton btnToggelShowMoreLess;
    private JCheckBox cbHideImportedScenerixxFiles;
    public JCheckBox cbShowAliases;
    public JCheckBox cbShowCounter;
    public JCheckBox cbShowLikeCounter;
    public JCheckBox cbShowPosition;
    public JCheckBox cbShowRating;
    public JCheckBox cbShowRuntime;
    public JComboBox<OrderByGender> comboOrderByGender;
    public JComboBox<OrderByPerson> comboOrderByPerson;
    private JComboBox<ShowHidePersonFilter> comboPersonFilter;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JLabel lbDirty;
    private JLabel lbOrderBy;
    private JLabel lbSearch;
    private JLabel lbShow;
    private JLabel lbShowHide;
    private JPanel panelImportScenerixxFiles;
    private JPanel panelOptions;
    private JTextField tfLimit;
    private JTextField tfSearch;
    public JToggleButton toggleBtnAsc;
    int reloads = 0;

    public PersonListTopComponent() {
        LocalDateTime now = LocalDateTime.now();
        LOG.info("Initialize Persons window " + String.valueOf(now));
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            StatusDisplayer.getDefault().setStatusText("Initializing Persons window");
            TopComponent dashboard = WindowManager.getDefault().findTopComponent("DashboardTopComponent");
            if (dashboard != null) {
                ((DashboardTopComponent)dashboard).setStatus("Initializing Persons window");
            }
        });
        this.initComponents();
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/vlc.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"icons.fatcow/dice.png"), (int)4, (int)4);
        this.btnOpenRandomized.setIcon(ImageUtilities.image2Icon((Image)image));
        this.toggleShowMoreLess();
        this.comboOrderByGender.setModel(new DefaultComboBoxModel<OrderByGender>(OrderByGender.values()));
        this.comboOrderByGender.setRenderer(new OrderByGenderComboRenderer());
        this.comboOrderByPerson.setModel(new DefaultComboBoxModel<OrderByPerson>(OrderByPerson.values()));
        this.comboOrderByPerson.setRenderer(new OrderByPersonComboRenderer());
        this.comboPersonFilter.setModel(new DefaultComboBoxModel<ShowHidePersonFilter>(ShowHidePersonFilter.values()));
        StandardContextMenu.addTo(this.tfSearch);
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(20);
        this.setName(Bundle.CTL_PersonListTopComponent());
        this.setToolTipText(Bundle.HINT_PersonListTopComponent());
        this.setMinimumSize(new Dimension(0, 0));
        UiState uiState = (UiState)this.db.getEntityService().find((EntityPathBase)QUiState.uiState).findFirst();
        if (uiState == null) {
            uiState = new UiState();
        }
        this.toggleBtnAsc.setSelected(uiState.isPersonlistAsc());
        this.cbShowAliases.setSelected(uiState.isPersonlistAliases());
        this.cbShowCounter.setSelected(uiState.isPersonlistCounter());
        this.cbShowLikeCounter.setSelected(uiState.isPersonlistCounterICame());
        if (uiState.getPersonlistMovieOrderByGender() != null && uiState.getPersonlistMovieOrderByGender().equals((Object)OrderByGender.RemindsMeOf) && !Scenerixx.unlocked) {
            this.comboOrderByGender.setSelectedItem(OrderByGender.All);
        } else {
            this.comboOrderByGender.setSelectedItem(uiState.getPersonlistMovieOrderByGender());
        }
        this.comboOrderByPerson.setSelectedItem(uiState.getPersonlistMovieOrderByPerson());
        this.cbShowPosition.setSelected(uiState.isPersonlistPosition());
        this.cbShowRating.setSelected(uiState.isPersonlistRating());
        this.cbShowRuntime.setSelected(uiState.isPersonlistRuntime());
        this.asc = uiState.isMovielistAsc();
        this.toggleAsc();
        this.toggleIcons();
        this.cbHideImportedScenerixxFiles.setVisible(false);
        this.btnImportSelected.setVisible(false);
        this.btnReset.setVisible(false);
        this.tfLimit.setText("" + this.db.getScenerixxSettings().getInitialLimitPersons());
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)em, (ActionMap)this.getActionMap()));
        em.addPropertyChangeListener(evt -> {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node[] selectedNodes = em.getSelectedNodes();
                ScenerixxCommon.setSelectedNodesInTitle(selectedNodes.length, "person");
            }
            if (em.getSelectedNodes().length == 1 && em.getSelectedNodes()[0].getValue("scene") != null) {
                Scene s = (Scene)em.getSelectedNodes()[0].getValue("scene");
                TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
                if (movieList != null) {
                    ((MovieListTopComponent)movieList).selectSceneNode(s);
                }
            }
            if (em.getSelectedNodes().length == 1 && em.getSelectedNodes()[0].getValue("person") != null) {
                Person p = (Person)em.getSelectedNodes()[0].getValue("person");
                this.reloadPersonDetails(p);
            }
            if (em.getSelectedNodes().length > 0 && this.showScenerixxFiles) {
                this.btnImportSelected.setEnabled(true);
            } else if (em.getSelectedNodes().length > 0) {
                this.btnOpen.setEnabled(true);
                this.btnOpenRandomized.setEnabled(true);
                this.btnCreatePlaylist.setEnabled(true);
                this.btnAddToDefaultPlaylist.setEnabled(true);
            } else {
                this.btnOpen.setEnabled(false);
                this.btnOpenRandomized.setEnabled(false);
                this.btnCreatePlaylist.setEnabled(false);
                this.btnAddToDefaultPlaylist.setEnabled(true);
                this.btnImportSelected.setEnabled(false);
                this.btnAddToDefaultPlaylist.setEnabled(false);
            }
        });
        KeyStroke keyEnter = KeyStroke.getKeyStroke(10, 2);
        AbstractAction openSelectedItems = new AbstractAction("OpenSelectedItemsFromPersonList"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PersonListTopComponent.this.openSelectedPlayableItems(false);
            }
        };
        this.beanTreeView1.getActionMap().put("OpenSelectedItemsFromPersonList", openSelectedItems);
        this.beanTreeView1.getInputMap(1).put(keyEnter, "OpenSelectedItemsFromPersonList");
        KeyStroke keyAddPerson = KeyStroke.getKeyStroke(65, 8);
        AbstractAction addPersonToScene = new AbstractAction("addPersonToScene"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PersonListTopComponent.this.addPersonToScene();
            }
        };
        this.beanTreeView1.getActionMap().put("addPersonToScene", addPersonToScene);
        this.beanTreeView1.getInputMap(1).put(keyAddPerson, "addPersonToScene");
        KeyStroke keyInsert = KeyStroke.getKeyStroke(80, 128);
        AbstractAction addToPlaylist = new AbstractAction("AddToPlaylist"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PersonListTopComponent.this.addToDefaultPlaylist(em.getSelectedNodes());
            }
        };
        this.beanTreeView1.getActionMap().put("AddToPlaylist", addToPlaylist);
        this.beanTreeView1.getInputMap(1).put(keyInsert, "AddToPlaylist");
        KeyStroke keyDelete = KeyStroke.getKeyStroke(127, 0);
        this.beanTreeView1.getActionMap().put("performDelete", (Action)SharedClassObject.findObject(DeletePersonAction.class, (boolean)true));
        this.beanTreeView1.getInputMap(1).put(keyDelete, "performDelete");
        KeyStroke keyF6 = KeyStroke.getKeyStroke(117, 0);
        AbstractAction performAddToClipboard = new AbstractAction("performAddToClipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOG.info("copy");
                if (em.getSelectedNodes().length > 0) {
                    String displayname = "";
                    for (Node n : em.getSelectedNodes()) {
                        if (n.getValue("person") != null) {
                            PersonListTopComponent.this.clipboard((IPlayablePlaylistItems)((Person)n.getValue("person")));
                            displayname = ((Person)n.getValue("person")).getName();
                        }
                        if (n.getValue("scene") != null) {
                            PersonListTopComponent.this.clipboard((IPlayablePlaylistItems)((Scene)n.getValue("scene")));
                            displayname = ((Scene)n.getValue("scene")).getNameOfPlayable();
                        }
                        if (n.getValue("bookmark") != null) {
                            PersonListTopComponent.this.clipboard((IPlayablePlaylistItems)((Bookmark)n.getValue("bookmark")));
                            displayname = ((Bookmark)n.getValue("bookmark")).getNameOfPlayable();
                        }
                        AbstractTopComponent.notifyInfo("added to temporary playlist: " + displayname);
                        LOG.info("added to temporary playlist: " + displayname);
                    }
                    AbstractTopComponent.reloadPlaylist("[TEMPORARY PLAYLIST]");
                }
            }
        };
        this.beanTreeView1.getActionMap().put("performAddToClipboard", performAddToClipboard);
        this.beanTreeView1.getInputMap(1).put(keyF6, "performAddToClipboard");
        AbstractAction reloadAction = new AbstractAction("reload"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PersonListTopComponent.this.reloadList();
            }
        };
        KeyStroke keyF5 = KeyStroke.getKeyStroke(116, 0);
        this.beanTreeView1.getActionMap().put("reload", reloadAction);
        this.beanTreeView1.getInputMap(1).put(keyF5, "reload");
        AbstractAction randomSelectAction = new AbstractAction("randomSelect"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PersonListTopComponent.this.selectRandomNode();
            }
        };
        KeyStroke keyCtrlR = KeyStroke.getKeyStroke(82, 128);
        this.beanTreeView1.getActionMap().put("randomSelect", randomSelectAction);
        this.beanTreeView1.getInputMap(1).put(keyCtrlR, "randomSelect");
        AbstractAction randomOpenAction = new AbstractAction("randomOpen"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PersonListTopComponent.this.openSelectedPlayableItems(true);
            }
        };
        KeyStroke keyAltR = KeyStroke.getKeyStroke(82, 512);
        this.beanTreeView1.getActionMap().put("randomOpen", randomOpenAction);
        this.beanTreeView1.getInputMap(1).put(keyAltR, "randomOpen");
        this.autocompleter.getAutoComplete().attachTo(this.tfSearch);
        if (this.cbShowRuntime.isSelected()) {
            PersonListTopComponent.notifyWarning("You selected to show the runtime for each person. This can decrease performance drastically.\nConsider turning this option off.");
        }
        PersonChildFactory personChildFactory = new PersonChildFactory(new ArrayList<Person>(), this.cbShowCounter.isSelected(), this.showBirthyear, this.showRating, this.showICame, this.showRuntime, false, this.cbShowPosition.isSelected());
        AbstractNode abstractNode = this.createAbstractRootNode(personChildFactory, ImageUtilities.loadImage((String)"icons/persons.png"));
        em.setRootContext((Node)abstractNode);
        em.getRootContext().setDisplayName("Press reload to load the list or use the context menu");
        this.initialized = true;
        if (!this.db.getScenerixxSettings().isLoadPersonsOnStartup()) {
            LOG.info("Person list should not be loaded during startup");
            this.setDirty();
            return;
        }
        this.reloadList();
        LOG.info("finished initializing person list window " + Duration.between(LocalDateTime.now(), now).toString());
    }

    public Person getSelectedPerson() {
        if (em.getSelectedNodes().length == 1 && em.getSelectedNodes()[0].getValue("person") != null && em.getSelectedNodes()[0].getValue("person") instanceof Person) {
            return (Person)em.getSelectedNodes()[0].getValue("person");
        }
        return null;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.beanTreeView1 = new ScenerixxBeanTreeView();
        this.btnOpen = new JButton();
        this.btnOpenRandomized = new JButton();
        this.btnCreatePlaylist = new JButton();
        this.btnSelectRandomNode = new JButton();
        this.btnAddToDefaultPlaylist = new JButton();
        this.lbDirty = new JLabel();
        this.btnReload = new JButton();
        this.jPanel2 = new JPanel();
        this.btnToggelShowMoreLess = new JToggleButton();
        this.comboOrderByPerson = new JComboBox();
        this.jSeparator1 = new JSeparator();
        this.toggleBtnAsc = new JToggleButton();
        this.tfSearch = new JTextField();
        this.comboOrderByGender = new JComboBox();
        this.panelOptions = new JPanel();
        this.cbShowLikeCounter = new JCheckBox();
        this.cbShowRating = new JCheckBox();
        this.cbShowPosition = new JCheckBox();
        this.cbShowAliases = new JCheckBox();
        this.cbShowRuntime = new JCheckBox();
        this.cbShowCounter = new JCheckBox();
        this.comboPersonFilter = new JComboBox();
        this.lbShowHide = new JLabel();
        this.lbShow = new JLabel();
        this.lbOrderBy = new JLabel();
        this.lbSearch = new JLabel();
        this.panelImportScenerixxFiles = new JPanel();
        this.btnImportSelected = new JButton();
        this.btnReset = new JButton();
        this.cbHideImportedScenerixxFiles = new JCheckBox();
        this.tfLimit = new JTextField();
        this.btnOpen.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/vlc.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpen, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.btnOpen.text"));
        this.btnOpen.setEnabled(false);
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.btnOpenActionPerformed(evt);
            }
        });
        this.btnOpenRandomized.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/vlc.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpenRandomized, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.btnOpenRandomized.text"));
        this.btnOpenRandomized.setToolTipText(NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.btnOpenRandomized.toolTipText"));
        this.btnOpenRandomized.setEnabled(false);
        this.btnOpenRandomized.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.btnOpenRandomizedActionPerformed(evt);
            }
        });
        this.btnCreatePlaylist.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Script.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnCreatePlaylist, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.btnCreatePlaylist.text"));
        this.btnCreatePlaylist.setToolTipText(NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.btnCreatePlaylist.toolTipText"));
        this.btnCreatePlaylist.setEnabled(false);
        this.btnCreatePlaylist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.btnCreatePlaylistActionPerformed(evt);
            }
        });
        this.btnSelectRandomNode.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/dice.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectRandomNode, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.btnSelectRandomNode.text"));
        this.btnSelectRandomNode.setToolTipText(NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.btnSelectRandomNode.toolTipText"));
        this.btnSelectRandomNode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.btnSelectRandomNodeActionPerformed(evt);
            }
        });
        this.btnAddToDefaultPlaylist.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/notes.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnAddToDefaultPlaylist, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.btnAddToDefaultPlaylist.text"));
        this.btnAddToDefaultPlaylist.setToolTipText(NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.btnAddToDefaultPlaylist.toolTipText"));
        this.btnAddToDefaultPlaylist.setEnabled(false);
        this.btnAddToDefaultPlaylist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.btnAddToDefaultPlaylistActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbDirty, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.lbDirty.text"));
        this.btnReload.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReload, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.btnReload.text"));
        this.btnReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.btnReloadActionPerformed(evt);
            }
        });
        this.btnToggelShowMoreLess.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Add.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnToggelShowMoreLess, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.btnToggelShowMoreLess.text"));
        this.btnToggelShowMoreLess.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.btnToggelShowMoreLessActionPerformed(evt);
            }
        });
        this.comboOrderByPerson.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.comboOrderByPersonActionPerformed(evt);
            }
        });
        this.jSeparator1.setOrientation(1);
        this.toggleBtnAsc.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/sort_ascending.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.toggleBtnAsc, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.toggleBtnAsc.text"));
        this.toggleBtnAsc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.toggleBtnAscActionPerformed(evt);
            }
        });
        this.tfSearch.setText(NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.tfSearch.text"));
        this.tfSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                PersonListTopComponent.this.tfSearchKeyReleased(evt);
            }
        });
        this.comboOrderByGender.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.comboOrderByGenderActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowLikeCounter, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.cbShowLikeCounter.text"));
        this.cbShowLikeCounter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.cbShowLikeCounterActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowRating, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.cbShowRating.text"));
        this.cbShowRating.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.cbShowRatingActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowPosition, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.cbShowPosition.text"));
        this.cbShowPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.cbShowPositionActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowAliases, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.cbShowAliases.text"));
        this.cbShowAliases.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.cbShowAliasesActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowRuntime, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.cbShowRuntime.text"));
        this.cbShowRuntime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.cbShowRuntimeActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowCounter, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.cbShowCounter.text"));
        this.cbShowCounter.setToolTipText(NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.cbShowCounter.toolTipText"));
        this.cbShowCounter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.cbShowCounterActionPerformed(evt);
            }
        });
        this.comboPersonFilter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.comboPersonFilterActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbShowHide, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.lbShowHide.text"));
        GroupLayout panelOptionsLayout = new GroupLayout(this.panelOptions);
        this.panelOptions.setLayout(panelOptionsLayout);
        panelOptionsLayout.setHorizontalGroup(panelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelOptionsLayout.createSequentialGroup().addComponent(this.lbShowHide).addGap(18, 18, 18).addGroup(panelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelOptionsLayout.createSequentialGroup().addComponent(this.comboPersonFilter, -2, 299, -2).addGap(0, 6, Short.MAX_VALUE)).addGroup(panelOptionsLayout.createSequentialGroup().addGroup(panelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbShowRating).addComponent(this.cbShowCounter)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelOptionsLayout.createSequentialGroup().addComponent(this.cbShowRuntime).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowAliases).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowPosition)).addComponent(this.cbShowLikeCounter)).addContainerGap(12, Short.MAX_VALUE)))));
        panelOptionsLayout.setVerticalGroup(panelOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelOptionsLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(panelOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbShowHide).addComponent(this.comboPersonFilter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbShowRating).addComponent(this.cbShowRuntime).addComponent(this.cbShowAliases).addComponent(this.cbShowPosition)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(panelOptionsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbShowCounter).addComponent(this.cbShowLikeCounter))));
        Mnemonics.setLocalizedText((JLabel)this.lbShow, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.lbShow.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbOrderBy, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.lbOrderBy.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbSearch, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.lbSearch.text"));
        this.btnImportSelected.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons2/54downarrow.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnImportSelected, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.btnImportSelected.text"));
        this.btnImportSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.btnImportSelectedActionPerformed(evt);
            }
        });
        this.btnReset.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/No.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReset, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.btnReset.text"));
        this.btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.btnResetActionPerformed(evt);
            }
        });
        this.cbHideImportedScenerixxFiles.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbHideImportedScenerixxFiles, (String)NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.cbHideImportedScenerixxFiles.text"));
        this.cbHideImportedScenerixxFiles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.cbHideImportedScenerixxFilesActionPerformed(evt);
            }
        });
        GroupLayout panelImportScenerixxFilesLayout = new GroupLayout(this.panelImportScenerixxFiles);
        this.panelImportScenerixxFiles.setLayout(panelImportScenerixxFilesLayout);
        panelImportScenerixxFilesLayout.setHorizontalGroup(panelImportScenerixxFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelImportScenerixxFilesLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelImportScenerixxFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbHideImportedScenerixxFiles).addGroup(panelImportScenerixxFilesLayout.createSequentialGroup().addComponent(this.btnImportSelected).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReset))).addContainerGap()));
        panelImportScenerixxFilesLayout.setVerticalGroup(panelImportScenerixxFilesLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelImportScenerixxFilesLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(panelImportScenerixxFilesLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnImportSelected).addComponent(this.btnReset)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbHideImportedScenerixxFiles)));
        this.tfLimit.setText(NbBundle.getMessage(PersonListTopComponent.class, (String)"PersonListTopComponent.tfLimit.text"));
        this.tfLimit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PersonListTopComponent.this.tfLimitActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panelImportScenerixxFiles, -1, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.btnToggelShowMoreLess).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toggleBtnAsc)).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.tfLimit, -2, 66, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 13, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.lbSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSearch)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.lbShow).addGap(15, 15, 15).addComponent(this.comboOrderByGender, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lbOrderBy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboOrderByPerson, -2, -1, -2)).addComponent(this.panelOptions, -2, -1, -2)))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tfSearch, -2, -1, -2).addComponent(this.lbSearch)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboOrderByGender, -2, -1, -2).addComponent(this.lbOrderBy).addComponent(this.comboOrderByPerson, -2, -1, -2).addComponent(this.lbShow))).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.toggleBtnAsc).addComponent(this.btnToggelShowMoreLess)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfLimit, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.panelOptions, -2, -1, -2)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jSeparator1, -2, 90, -2).addGap(0, 0, 0))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.panelImportScenerixxFiles, -1, -1, Short.MAX_VALUE).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.beanTreeView1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.lbDirty).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReload)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.btnSelectRandomNode, -2, 34, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOpenRandomized).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAddToDefaultPlaylist).addGap(0, 0, 0).addComponent(this.btnCreatePlaylist).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOpen))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbDirty).addComponent(this.btnReload)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnCreatePlaylist).addComponent(this.btnAddToDefaultPlaylist).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOpen).addComponent(this.btnOpenRandomized).addComponent(this.btnSelectRandomNode))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.beanTreeView1, -1, 412, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
        this.jScrollPane1.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jScrollPane1, -1, 473, Short.MAX_VALUE).addGap(1, 1, 1)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jScrollPane1).addGap(1, 1, 1)));
    }

    private void cbShowPositionActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void btnCreatePlaylistActionPerformed(ActionEvent evt) {
        this.createPlaylist();
    }

    private void btnOpenRandomizedActionPerformed(ActionEvent evt) {
        this.openSelectedPlayableItems(true);
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        this.openSelectedPlayableItems(false);
    }

    private void cbShowCounterActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void cbShowRuntimeActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void btnImportSelectedActionPerformed(ActionEvent evt) {
        this.importSelected();
    }

    private void cbShowRatingActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void tfSearchKeyReleased(KeyEvent evt) {
        List searchQueries = this.db.getEntityService().find((EntityPathBase)QSearchQuery.searchQuery1).filter(f -> f.tab.eq((Object)Tab.Persons)).filter(f -> f.searchQuery.containsIgnoreCase(this.tfSearch.getText())).order(new Function[]{f -> f.dateOfCreation.desc()}).find(20L);
        this.autocompleter.getChoices().clear();
        this.autocompleter.getChoices().addAll(searchQueries);
        if (this.db.getScenerixxSettings().isSearchOnKeyPress() || evt.getKeyCode() == 10) {
            if (evt.getKeyCode() == 37 || evt.getKeyCode() == 39 || evt.getKeyCode() == 34 || evt.getKeyCode() == 33 || evt.getKeyCode() == 32) {
                LOG.finest("Cursor key or space pressed, skip search");
            } else {
                new UpdateSearchResultListWorker().execute();
            }
        }
    }

    private void cbShowAliasesActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void cbShowLikeCounterActionPerformed(ActionEvent evt) {
        this.toggleIcons();
        this.reloadList();
    }

    private void cbHideImportedScenerixxFilesActionPerformed(ActionEvent evt) {
        this.loadPersonFiles();
    }

    private void btnSelectRandomNodeActionPerformed(ActionEvent evt) {
        this.selectRandomNode();
    }

    private void btnAddToDefaultPlaylistActionPerformed(ActionEvent evt) {
        this.addToDefaultPlaylist();
    }

    private void btnToggelShowMoreLessActionPerformed(ActionEvent evt) {
        this.toggleShowMoreLess();
    }

    private void comboOrderByGenderActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void comboOrderByPersonActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void toggleBtnAscActionPerformed(ActionEvent evt) {
        this.toggleAsc();
    }

    private void comboPersonFilterActionPerformed(ActionEvent evt) {
        this.filterChanged();
    }

    private void btnReloadActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void btnResetActionPerformed(ActionEvent evt) {
        this.reloadList(false);
    }

    private void tfLimitActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    public void setDirty() {
        this.setDirty(false);
    }

    public void setDirty(boolean clearList) {
        this.lbDirty.setVisible(true);
        this.btnReload.setVisible(true);
        if (clearList) {
            this.setRootContext(new ArrayList<Person>(), false);
        }
    }

    public void filterChanged() {
        File findProfileFile;
        ArrayList tmpPersons;
        LOG.info("filter changed to: " + String.valueOf(this.comboPersonFilter.getSelectedItem()));
        if (ShowHidePersonFilter.ShowAllPersons.equals(this.comboPersonFilter.getSelectedItem())) {
            this.reloadList();
            return;
        }
        List persons = OrderByGender.Female.equals(this.comboOrderByGender.getSelectedItem()) ? this.db.getPersons(Gender.FEMALE, false, Scenerixx.unlocked, (long)Integer.parseInt(this.tfLimit.getText())) : (OrderByGender.Male.equals(this.comboOrderByGender.getSelectedItem()) ? this.db.getPersons(Gender.MALE, false, Scenerixx.unlocked, (long)Integer.parseInt(this.tfLimit.getText())) : (OrderByGender.TS.equals(this.comboOrderByGender.getSelectedItem()) ? this.db.getPersons(Gender.TS, false, Scenerixx.unlocked, (long)Integer.parseInt(this.tfLimit.getText())) : this.db.getPersons(Scenerixx.unlocked, (long)Integer.parseInt(this.tfLimit.getText()))));
        if (ShowHidePersonFilter.ShowOnlyPersonsWithNoProfilePicture.equals(this.comboPersonFilter.getSelectedItem())) {
            LOG.info("show only person with no profile picture");
            tmpPersons = new ArrayList(persons);
            for (Person p : tmpPersons) {
                findProfileFile = this.findProfileFile(p.getName(), new File(this.db.getScenerixxSettings().getProfilePictureDirectory()));
                if (findProfileFile == null) continue;
                persons.remove(p);
                LOG.info(p.getName() + " has a normal profile picture");
            }
            tmpPersons.clear();
            tmpPersons = new ArrayList(persons);
            for (Person p : tmpPersons) {
                findProfileFile = this.scenerixxCommon.findRandomProfileFile(p.getName());
                if (findProfileFile == null) continue;
                persons.remove(p);
                LOG.info(p.getName() + " has a profile directory");
            }
            tmpPersons.clear();
            tmpPersons = new ArrayList(persons);
            for (Person p : tmpPersons) {
                findProfileFile = this.scenerixxCommon.findProfileFile(p.getName(), new File(this.db.getScenerixxSettings().getProfilePictureDirectory()), true);
                if (findProfileFile == null) continue;
                persons.remove(p);
                LOG.info(p.getName() + " has a nsfw profile picture");
            }
            this.setRootContext(persons, false);
        }
        if (ShowHidePersonFilter.ShowOnlyPersonsWithNsfwProfilePictureMissing.equals(this.comboPersonFilter.getSelectedItem())) {
            LOG.info("show only persons without nsfw picture");
            tmpPersons = new ArrayList(persons);
            for (Person p : tmpPersons) {
                findProfileFile = this.scenerixxCommon.findProfileFile(p.getName(), new File(this.db.getScenerixxSettings().getProfilePictureDirectory()), true);
                if (findProfileFile == null) continue;
                persons.remove(p);
                LOG.info(p.getName() + " has a nsfw profile picture");
            }
            this.setRootContext(persons, false);
        }
        if (ShowHidePersonFilter.ShowOnlyPersonsWithPictureDirectoryMissing.equals(this.comboPersonFilter.getSelectedItem())) {
            LOG.info("show only persons without picture directory");
            tmpPersons = new ArrayList(persons);
            for (Person p : tmpPersons) {
                findProfileFile = this.scenerixxCommon.findRandomProfileFile(p.getName());
                if (findProfileFile == null) continue;
                persons.remove(p);
                LOG.info(p.getName() + " has a profile directory");
            }
            this.setRootContext(persons, false);
        }
        if (ShowHidePersonFilter.ShowOnlyPersonsWithProfilePictureMissing.equals(this.comboPersonFilter.getSelectedItem())) {
            LOG.info("show only persons without profile picture");
            tmpPersons = new ArrayList(persons);
            for (Person p : tmpPersons) {
                findProfileFile = this.findProfileFile(p.getName(), new File(this.db.getScenerixxSettings().getProfilePictureDirectory()));
                if (findProfileFile == null) continue;
                persons.remove(p);
                LOG.info(p.getName() + " has a normal profile picture");
            }
            this.setRootContext(persons, false);
        }
    }

    private File findProfileFile(String personName, File startDirectory) {
        File findProfileFile = null;
        if (Scenerixx.unlocked && findProfileFile == null) {
            LOG.fine("Try to find a nsfw picture");
            findProfileFile = this.scenerixxCommon.findProfileFile(personName, startDirectory, true);
        }
        if (findProfileFile == null || !Scenerixx.unlocked) {
            LOG.fine("Try to find a normal profile picture");
            findProfileFile = this.scenerixxCommon.findProfileFile(personName, startDirectory, false);
        }
        return findProfileFile;
    }

    private void toggleAsc() {
        boolean bl = this.asc = !this.asc;
        if (this.asc) {
            this.toggleBtnAsc.setToolTipText("sort ascending");
            this.toggleBtnAsc.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/sort_ascending.png")));
        } else {
            this.toggleBtnAsc.setToolTipText("sort descending");
            this.toggleBtnAsc.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/sort_descending.png")));
        }
        this.reloadList();
    }

    private void toggleShowMoreLess() {
        this.panelOptions.setVisible(this.btnToggelShowMoreLess.isSelected());
        if (this.btnToggelShowMoreLess.isSelected()) {
            this.btnToggelShowMoreLess.setToolTipText("Show Less");
            this.btnToggelShowMoreLess.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Remove.png")));
        } else {
            this.btnToggelShowMoreLess.setToolTipText("Show More...");
            this.btnToggelShowMoreLess.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Add.gif")));
        }
    }

    private void toggleIcons() {
        if (this.cbShowPosition.isSelected()) {
            this.cbShowPosition.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/text_list_numbers.png")));
        } else {
            this.cbShowPosition.setIcon(null);
        }
        if (this.cbShowLikeCounter.isSelected()) {
            this.cbShowLikeCounter.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons2/Heart.png")));
        } else {
            this.cbShowLikeCounter.setIcon(null);
        }
        if (this.cbShowCounter.isSelected()) {
            this.cbShowCounter.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/counter.png")));
        } else {
            this.cbShowCounter.setIcon(null);
        }
        if (this.cbShowRating.isSelected()) {
            this.cbShowRating.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/favourites.png")));
        } else {
            this.cbShowRating.setIcon(null);
        }
        if (this.cbShowRuntime.isSelected()) {
            this.cbShowRuntime.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Stopwatch.png")));
        } else {
            this.cbShowRuntime.setIcon(null);
        }
        if (this.cbShowAliases.isSelected()) {
            this.cbShowAliases.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/user_silhouette.png")));
        } else {
            this.cbShowAliases.setIcon(null);
        }
    }

    private void selectRandomNode() {
        Random rnd = new Random();
        int nodesCount = em.getRootContext().getChildren().getNodesCount();
        if (nodesCount <= 0) {
            return;
        }
        int nextInt = rnd.nextInt(nodesCount);
        Node child = em.getRootContext().getChildren().getNodeAt(nextInt);
        if (child != null) {
            try {
                em.setSelectedNodes(new Node[]{child});
                this.beanTreeView1.expandNode(child);
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void addToPlaylist(Playlist playlist) {
        if (em.getSelectedNodes().length >= 1) {
            for (Node n : em.getSelectedNodes()) {
                Bookmark bookmark = (Bookmark)n.getValue("bookmark");
                Scene scene = (Scene)n.getValue("scene");
                Movie movie = (Movie)n.getValue("movie");
                Person person = (Person)n.getValue("person");
                PlaylistEntry pe = new PlaylistEntry();
                if (bookmark != null) {
                    pe.setBookmark(bookmark);
                    playlist.getEntries(Scenerixx.unlocked).add(pe);
                    continue;
                }
                if (movie != null) {
                    pe.setMovie(movie);
                    playlist.getEntries(Scenerixx.unlocked).add(pe);
                    continue;
                }
                if (scene != null) {
                    pe.setScene(scene);
                    playlist.getEntries(Scenerixx.unlocked).add(pe);
                    continue;
                }
                if (person == null) continue;
                int dvds = 0;
                for (Scene s : this.db.getScenes(person, Scenerixx.unlocked)) {
                    if (this.db.getDvd(s.getMovie(), Scenerixx.unlocked) == null) {
                        PlaylistEntry pe2 = new PlaylistEntry();
                        pe2.setScene(s);
                        pe2.setDateOfCreation(LocalDateTime.now());
                        playlist.getEntries(Scenerixx.unlocked).add(pe2);
                        continue;
                    }
                    ++dvds;
                }
                LOG.fine(dvds + " scenes will be ignored because they are on a DVD");
            }
            this.db.getEntityService().save((AbstractEntity)playlist);
            AbstractTopComponent.reloadPlaylist(playlist.getName());
            AbstractTopComponent.notifyInfo("Added " + playlist.getEntries(Scenerixx.unlocked).size() + " items to playlist " + playlist.getName());
        }
    }

    public void addToDefaultPlaylist() {
        Playlist playlist = this.ps.getDefaultPlaylist(Scenerixx.unlocked);
        this.addToPlaylist(playlist);
    }

    public void createPlaylist() {
        Playlist playlist = new Playlist();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm");
        playlist.setName("[New Playlist " + df.format(LocalDateTime.now()) + "]");
        this.addToPlaylist(playlist);
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void importSelected() {
        Object importedPersons = "";
        for (Node n : em.getSelectedNodes()) {
            Person p = (Person)n.getValue("person");
            if (p == null) continue;
            try {
                if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)p.getName())).count() > 0L) {
                    AbstractTopComponent.notifyError("There is already a person with the name " + p.getName() + ". I cannot handle this. Either delete the existing person or rename the person to import.");
                    continue;
                }
                this.db.getEntityService().save((AbstractEntity)p);
                this.reloadList();
                importedPersons = (String)importedPersons + p.getName() + "  ";
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
            }
        }
        if (!((String)importedPersons).isEmpty()) {
            JOptionPane.showMessageDialog(null, "Imported: " + (String)importedPersons);
        }
    }

    private void loadPersonFiles() {
        ArrayList<Person> tmpPersons = new ArrayList<Person>();
        Importer imp = new Importer();
        LOG.fine("Loading Scenerixx-files");
        try (Stream<Path> paths = Files.walk(Paths.get(Scenerixx.scenerixxFilesDirBase + Scenerixx.scenerixxFilesDirPersons, new String[0]), new FileVisitOption[0]);){
            for (Path filePath : paths.collect(Collectors.toList())) {
                if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                try {
                    LOG.finest("Found a file: " + filePath.toString());
                    if (!filePath.toString().endsWith("person.scenerixx") && !filePath.toString().endsWith("person.private.scenerixx")) continue;
                    Person importPersonFile = imp.importPersonFile(filePath.toString(), false);
                    if (this.cbHideImportedScenerixxFiles.isSelected()) {
                        LOG.finest("Check if person is already imported.");
                        if (this.db.getEntityService().find((EntityPathBase)QPerson.person).filter(f -> f.name.eq((Object)importPersonFile.getName())).count() == 0L) {
                            LOG.finest("Was not yet imported");
                            tmpPersons.add(importPersonFile);
                            continue;
                        }
                        LOG.finest("Was already imported");
                        continue;
                    }
                    LOG.fine("Loading " + filePath.toString());
                    tmpPersons.add(importPersonFile);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notifyError("Could not load person files. An error occured: " + ex.getMessage());
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            AbstractTopComponent.notifyError("Could not load person files. An error occured: " + ex.getMessage());
        }
        tmpPersons.sort((one, other) -> one.getName().compareTo(other.getName()));
        this.setRootContext(tmpPersons, true);
    }

    public ExplorerManager getExplorerManager() {
        return em;
    }

    public void reloadList(String nameOfPersonToSelect) {
        this.reloadList(false);
        this.selectPersonNode(nameOfPersonToSelect);
    }

    public void selectPersonNode(String nameOfPersonToSelect) {
        SwingUtilities.invokeLater(() -> {
            if (nameOfPersonToSelect == null || nameOfPersonToSelect.isEmpty()) {
                LOG.info("Cannot select person node. Empty name was passed. De-select any selection.");
                try {
                    em.setSelectedNodes(new Node[0]);
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return;
            }
            LocalDateTime now = LocalDateTime.now();
            this.checkIfPersonInSearchResults(nameOfPersonToSelect);
            Node findChild = em.getRootContext().getChildren().findChild(nameOfPersonToSelect);
            if (findChild != null) {
                LOG.fine("found person node: " + nameOfPersonToSelect);
                try {
                    Object patt0$temp;
                    em.setSelectedNodes(new Node[]{findChild});
                    if (findChild.getValue("person") != null && (patt0$temp = findChild.getValue("person")) instanceof Person) {
                        Person person = (Person)patt0$temp;
                        ArrayList<Person> persons = new ArrayList<Person>();
                        persons.add(person);
                        ShowPicturesAction.getInstance().showAllPersonPictures(persons, true);
                    }
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notifyError("Could not select person node. An error occured: " + ex.getMessage());
                }
            } else {
                LOG.fine("did NOT findperson node: " + nameOfPersonToSelect);
                SwingUtilities.invokeLater(() -> {
                    TopComponent detailsList = WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                    Person person = this.db.getPerson(nameOfPersonToSelect, Scenerixx.unlocked);
                    if (detailsList != null && detailsList instanceof DetailsTopComponent) {
                        DetailsTopComponent tc = (DetailsTopComponent)detailsList;
                        if (person != null) {
                            tc.getPersonDetailsPanel().loadForm(person);
                        }
                    }
                });
            }
            LOG.fine("finished select person node - " + Duration.between(LocalDateTime.now(), now).toString());
        });
    }

    private void checkIfPersonInSearchResults(String nameOfPersonToSelect) {
        LOG.fine("name of person to select: " + nameOfPersonToSelect);
        if (!this.tfSearch.getText().isEmpty()) {
            boolean needToAdd = true;
            for (String s : this.tfSearch.getText().split(" ")) {
                if (!nameOfPersonToSelect.contains(s)) continue;
                needToAdd = false;
            }
            if (needToAdd) {
                String sepator = " ";
                if (this.tfSearch.getText().contains(",")) {
                    sepator = ", ";
                }
                this.tfSearch.setText(this.tfSearch.getText() + sepator + nameOfPersonToSelect);
                this.reloadList(nameOfPersonToSelect);
            }
        }
    }

    public void reloadList() {
        if (this.initialized) {
            this.reloadList(false);
        } else {
            this.setDirty();
        }
    }

    public void showOnlyPersonsWithoutScenerixxFile() {
        List persons = this.db.getPersons(false, Scenerixx.unlocked);
        ArrayList<Person> tmpPersons = new ArrayList<Person>();
        Importer imp = new Importer();
        try (Stream<Path> paths = Files.walk(Paths.get(Scenerixx.scenerixxFilesDirBase + Scenerixx.scenerixxFilesDirPersons, new String[0]), new FileVisitOption[0]);){
            for (Path filePath : paths.collect(Collectors.toList())) {
                if (Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS)) continue;
                try {
                    LOG.finest("Found a file: " + filePath.toString());
                    if (!filePath.toString().endsWith("person.scenerixx") && !filePath.toString().endsWith("person.private.scenerixx")) continue;
                    Person importPersonFile = imp.importPersonFile(filePath.toString(), false);
                    tmpPersons.add(importPersonFile);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
        }
        tmpPersons.sort((one, other) -> one.getName().compareTo(other.getName()));
        block10: for (Person p : tmpPersons) {
            for (Person p2 : persons) {
                if (!p.getName().equals(p2.getName())) continue;
                persons.remove(p2);
                continue block10;
            }
        }
        this.setRootContext(persons, false);
    }

    public void reloadList(boolean showScenerixxFiles) {
        this.showScenerixxFiles = showScenerixxFiles;
        SwingUtilities.invokeLater(() -> {
            if (!this.initialized) {
                LOG.fine("Still in initialization phase. Abort person list reload.");
                return;
            }
            LocalDateTime now = LocalDateTime.now();
            Long limit = Long.MAX_VALUE;
            try {
                if (!this.tfLimit.getText().isBlank()) {
                    limit = Long.valueOf(this.tfLimit.getText().trim());
                }
            }
            catch (Exception ex) {
                PersonListTopComponent.notifyWarning("Could not parse limit. Show all nodes.");
            }
            LOG.fine("Reload list: PersonList (" + this.reloads + ") - limit: " + limit + " - " + String.valueOf(now));
            this.showBirthyear = false;
            this.showRuntime = this.cbShowRuntime.isSelected();
            this.showRating = this.cbShowRating.isSelected();
            this.showICame = this.cbShowLikeCounter.isSelected();
            if (OrderByPerson.Birthyear.equals(this.comboOrderByPerson.getSelectedItem())) {
                this.showBirthyear = true;
            }
            if (OrderByPerson.Runtime.equals(this.comboOrderByPerson.getSelectedItem())) {
                this.showRuntime = true;
            }
            if (OrderByPerson.Rating.equals(this.comboOrderByPerson.getSelectedItem())) {
                this.showRating = true;
            }
            if (OrderByPerson.ICame.equals(this.comboOrderByPerson.getSelectedItem())) {
                this.showICame = true;
            }
            this.cbShowAliases.setVisible(true);
            String nameOfNodeToSelect = "";
            if (em.getSelectedNodes().length > 0) {
                nameOfNodeToSelect = em.getSelectedNodes()[0].getName();
            }
            this.cbHideImportedScenerixxFiles.setVisible(false);
            this.btnImportSelected.setVisible(false);
            this.btnReset.setVisible(false);
            if (OrderByPerson.Birthday.equals(this.comboOrderByPerson.getSelectedItem())) {
                this.reloadListBirthday();
            } else {
                Gender tmpGender = null;
                if (OrderByGender.Female.equals(this.comboOrderByGender.getSelectedItem())) {
                    tmpGender = Gender.FEMALE;
                } else if (OrderByGender.Male.equals(this.comboOrderByGender.getSelectedItem())) {
                    tmpGender = Gender.MALE;
                } else if (OrderByGender.TS.equals(this.comboOrderByGender.getSelectedItem())) {
                    tmpGender = Gender.TS;
                }
                this.btnToggelShowMoreLess.setEnabled(true);
                if (OrderByPerson.HairColor.equals(this.comboOrderByPerson.getSelectedItem())) {
                    this.cbShowAliases.setVisible(false);
                    this.setRootContextHairColor(tmpGender);
                } else if (OrderByPerson.BodyType.equals(this.comboOrderByPerson.getSelectedItem())) {
                    this.cbShowAliases.setVisible(false);
                    this.setRootContextBodyType(tmpGender);
                } else if (OrderByPerson.Appearance.equals(this.comboOrderByPerson.getSelectedItem())) {
                    this.cbShowAliases.setVisible(false);
                    this.setRootContextAppearance(tmpGender);
                } else if (OrderByPerson.Ethnicity.equals(this.comboOrderByPerson.getSelectedItem())) {
                    this.cbShowAliases.setVisible(false);
                    this.setRootContextEthnicity(tmpGender);
                } else if (OrderByPerson.Nationality.equals(this.comboOrderByPerson.getSelectedItem())) {
                    this.cbShowAliases.setVisible(false);
                    this.setRootContextNationality(tmpGender);
                } else if (OrderByPerson.Tits.equals(this.comboOrderByPerson.getSelectedItem())) {
                    this.cbShowAliases.setVisible(false);
                    this.setRootContextBodyPartSize(tmpGender, BodyPart.Tits);
                } else if (OrderByPerson.Ass.equals(this.comboOrderByPerson.getSelectedItem())) {
                    this.cbShowAliases.setVisible(false);
                    this.setRootContextBodyPartSize(tmpGender, BodyPart.Ass);
                } else if (showScenerixxFiles) {
                    this.cbHideImportedScenerixxFiles.setVisible(true);
                    this.btnImportSelected.setVisible(true);
                    this.btnReset.setVisible(true);
                    this.btnToggelShowMoreLess.setEnabled(false);
                    if (this.btnToggelShowMoreLess.isSelected()) {
                        this.btnToggelShowMoreLess.setSelected(false);
                        this.panelOptions.setVisible(false);
                        this.toggleShowMoreLess();
                    }
                    this.loadPersonFiles();
                } else if (OrderByGender.Male.equals(this.comboOrderByGender.getSelectedItem()) || OrderByGender.Female.equals(this.comboOrderByGender.getSelectedItem()) || OrderByGender.TS.equals(this.comboOrderByGender.getSelectedItem()) || OrderByGender.All.equals(this.comboOrderByGender.getSelectedItem())) {
                    Gender currentGender = null;
                    if (OrderByGender.Female.equals(this.comboOrderByGender.getSelectedItem())) {
                        currentGender = Gender.FEMALE;
                    } else if (OrderByGender.All.equals(this.comboOrderByGender.getSelectedItem())) {
                        currentGender = null;
                    } else if (OrderByGender.Male.equals(this.comboOrderByGender.getSelectedItem())) {
                        currentGender = Gender.MALE;
                    } else if (OrderByGender.TS.equals(this.comboOrderByGender.getSelectedItem())) {
                        currentGender = Gender.TS;
                    }
                    LOG.info("currentGender: " + String.valueOf(currentGender));
                    if (OrderByPerson.NumberOfAppearances.equals(this.comboOrderByPerson.getSelectedItem())) {
                        this.setRootContext(this.db.getPersonsByAppearance(currentGender, this.cbShowAliases.isSelected(), this.tfSearch.getText(), Scenerixx.unlocked), false);
                    } else if (OrderByPerson.DateOfCreation.equals(this.comboOrderByPerson.getSelectedItem())) {
                        this.setRootContext(this.db.getPersonsByDateOfCreation(currentGender, this.cbShowAliases.isSelected(), this.tfSearch.getText(), Scenerixx.unlocked), false);
                    } else if (OrderByPerson.Birthyear.equals(this.comboOrderByPerson.getSelectedItem())) {
                        this.setRootContext(this.db.getPersonsByBirthyear(currentGender, this.cbShowAliases.isSelected(), this.tfSearch.getText(), Scenerixx.unlocked), false);
                    } else if (OrderByPerson.Rating.equals(this.comboOrderByPerson.getSelectedItem())) {
                        this.setRootContext(this.db.getPersonsByRating(currentGender, this.cbShowAliases.isSelected(), this.tfSearch.getText(), Scenerixx.unlocked), false);
                    } else if (OrderByPerson.Runtime.equals(this.comboOrderByPerson.getSelectedItem())) {
                        this.setRootContext(this.db.getPersonsByRuntime(currentGender, this.cbShowAliases.isSelected(), this.tfSearch.getText(), Scenerixx.unlocked), false);
                    } else if (OrderByPerson.WizardGenerated.equals(this.comboOrderByPerson.getSelectedItem())) {
                        this.setRootContext(this.db.getPersonsByWizardGenerated(currentGender, true, Scenerixx.unlocked), false);
                    } else if (OrderByPerson.ICame.equals(this.comboOrderByPerson.getSelectedItem())) {
                        this.setRootContext(this.db.getPersonsByICame(currentGender, this.cbShowAliases.isSelected(), this.tfSearch.getText(), Scenerixx.unlocked), false);
                    } else {
                        this.setRootContext(this.db.getPersons(currentGender, this.cbShowAliases.isSelected(), this.tfSearch.getText(), Scenerixx.unlocked, limit.longValue(), true), false);
                    }
                } else if (OrderByGender.OnlyFavourites.equals(this.comboOrderByGender.getSelectedItem())) {
                    this.setRootContext(this.db.getFavoritePersons(this.cbShowAliases.isSelected(), this.tfSearch.getText(), Scenerixx.unlocked, limit.longValue()), false);
                } else if (OrderByGender.AllTimeFavourites.equals(this.comboOrderByGender.getSelectedItem())) {
                    this.setRootContext(this.db.getAllTimeFavoritePersons(limit.longValue()), false);
                } else if (OrderByGender.RemindsMeOf.equals(this.comboOrderByGender.getSelectedItem())) {
                    this.setRootContextRemindsMeOf(this.db.getRemindsMeOf(Scenerixx.unlocked));
                } else {
                    this.setRootContext(this.db.getPersons(null, this.cbShowAliases.isSelected(), this.tfSearch.getText(), Scenerixx.unlocked, limit.longValue()), false);
                    LOG.severe("THIS SHOULD NOT HAPPEN!!!!!!!!!!!!!!!!!!!");
                }
            }
            if (nameOfNodeToSelect.length() > 0) {
                LOG.fine("Try to select the last selected node: " + nameOfNodeToSelect);
                Node findChild = em.getRootContext().getChildren().findChild(nameOfNodeToSelect);
                if (findChild != null) {
                    LOG.fine("Last selected node " + String.valueOf(findChild));
                    try {
                        em.setSelectedNodes(new Node[]{findChild});
                    }
                    catch (PropertyVetoException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
                    }
                }
            }
            LOG.fine("finished reloading list: PersonList - " + Duration.between(LocalDateTime.now(), now).toString());
        });
        this.lbDirty.setVisible(false);
        this.btnReload.setVisible(false);
    }

    private void addSeveralPersonsToScene(List<Person> persons, Scene scene) {
        ArrayList<Person> tmpMales = new ArrayList<Person>();
        ArrayList<Object> tmpFemales = new ArrayList<Object>();
        ArrayList<Person> tmpTS = new ArrayList<Person>();
        for (Person person : persons) {
            if (Gender.MALE.equals((Object)person.getGender())) {
                tmpMales.add(person);
            }
            if (Gender.FEMALE.equals((Object)person.getGender())) {
                tmpFemales.add(person);
            }
            if (!Gender.TS.equals((Object)person.getGender())) continue;
            tmpTS.add(person);
        }
        Collections.sort(tmpFemales, new PersonComparator());
        Collections.sort(tmpTS, new PersonComparator());
        Collections.sort(tmpMales, new PersonComparator());
        tmpFemales.addAll(tmpTS);
        tmpFemales.addAll(tmpMales);
        for (Person person : tmpFemales) {
            boolean addPersonToScene = this.db.addPersonToScene(person, scene);
            if (addPersonToScene) {
                AbstractTopComponent.notifyInfo("added " + person.getName() + " to movie " + scene.getMovie().getTitle() + " scene " + scene.getPosition());
                continue;
            }
            AbstractTopComponent.notifyWarning(person.getName() + " is already added to this scene");
            this.scenerixxCommon.askToAddDuplicatePerson(person, scene);
        }
        scene = (Scene)this.db.getEntityService().save((AbstractEntity)scene);
    }

    public void addPersonToScene() {
        TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
        if (movieList != null && em.getSelectedNodes().length >= 1) {
            ArrayList<Person> persons = new ArrayList<Person>();
            for (Node n : em.getSelectedNodes()) {
                Person person = (Person)n.getValue("person");
                if (person == null) continue;
                persons.add(person);
            }
            if (((MovieListTopComponent)movieList).getSelectedScene() != null && !persons.isEmpty()) {
                this.addSeveralPersonsToScene(persons, ((MovieListTopComponent)movieList).getSelectedScene());
                detailTC = (DetailsTopComponent)WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                if (detailTC != null) {
                    detailTC.updateDisplayNameOfSelectedNode();
                }
                this.reloadList(((Person)persons.get(0)).getName());
            } else if (((MovieListTopComponent)movieList).getSelectedPlayable() != null && ((MovieListTopComponent)movieList).getSelectedPlayable() instanceof Movie && ((Movie)((MovieListTopComponent)movieList).getSelectedPlayable()).getScenes().size() == 1 && !persons.isEmpty()) {
                this.addSeveralPersonsToScene(persons, (Scene)((Movie)((MovieListTopComponent)movieList).getSelectedPlayable()).getScenes().get(0));
                detailTC = (DetailsTopComponent)WindowManager.getDefault().findTopComponent("DetailsTopComponent");
                if (detailTC != null) {
                    detailTC.updateDisplayNameOfSelectedNode();
                }
                this.reloadList(((Person)persons.get(0)).getName());
            } else {
                PersonListTopComponent.notify("Could not add persons to a scene", ImageUtilities.loadImageIcon((String)"icons/Info.png", (boolean)false), "Exactly one scene (or a movie with exact one scene) has to be selected and one or more person nodes.", null, NotificationDisplayer.Priority.LOW);
            }
        }
    }

    public void openSelectedPlayableItems(boolean randomized) {
        TopComponent movieList = WindowManager.getDefault().findTopComponent("MovieListTopComponent");
        if (movieList != null && em.getSelectedNodes().length >= 1) {
            Playlist tmpPlaylist = new Playlist();
            for (Node n : em.getSelectedNodes()) {
                Bookmark bookmark = (Bookmark)n.getValue("bookmark");
                Scene scene = (Scene)n.getValue("scene");
                Movie movie = (Movie)n.getValue("movie");
                Person person = (Person)n.getValue("person");
                PlaylistEntry pe = new PlaylistEntry();
                if (bookmark != null) {
                    pe.setBookmark(bookmark);
                    tmpPlaylist.getEntries(Scenerixx.unlocked).add(pe);
                    continue;
                }
                if (movie != null) {
                    pe.setMovie(movie);
                    tmpPlaylist.getEntries(Scenerixx.unlocked).add(pe);
                    continue;
                }
                if (scene != null) {
                    pe.setScene(scene);
                    tmpPlaylist.getEntries(Scenerixx.unlocked).add(pe);
                    continue;
                }
                if (person == null) continue;
                int dvds = 0;
                for (Scene s : this.db.getScenes(person, Scenerixx.unlocked)) {
                    if (this.db.getDvd(s.getMovie(), Scenerixx.unlocked) == null) {
                        PlaylistEntry pe2 = new PlaylistEntry();
                        pe2.setDateOfCreation(LocalDateTime.now());
                        pe2.setScene(s);
                        pe2.setPlaylist(tmpPlaylist);
                        tmpPlaylist.getEntries(Scenerixx.unlocked).add(pe2);
                        continue;
                    }
                    ++dvds;
                }
                LOG.fine(dvds + " scenes will be ignored because they are on a DVD");
            }
            ((MovieListTopComponent)movieList).openVlc(tmpPlaylist, true, randomized);
        }
    }

    public void clearSearchText() {
        this.tfSearch.setText("");
    }

    public void clearFilter() {
        this.tfLimit.setVisible(true);
        this.tfLimit.setText("" + this.db.getScenerixxSettings().getInitialLimitPersons());
        this.tfSearch.setText("");
        this.comboPersonFilter.setSelectedItem(ShowHidePersonFilter.ShowAllPersons);
    }

    public void setRootContext(List<Person> persons, boolean scenerixxFiles) {
        LOG.fine("root context person list- " + String.valueOf(LocalDateTime.now()));
        LocalDateTime now = LocalDateTime.now();
        if (!this.asc) {
            Collections.reverse(persons);
        }
        PersonChildFactory personChildFactory = null;
        personChildFactory = scenerixxFiles ? new PersonChildFactory(persons, "[Scenerixx-File]", true, false){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                PersonListTopComponent.this.reloadList(true);
            }
        } : new PersonChildFactory(persons, this.cbShowCounter.isSelected(), this.showBirthyear, this.showRating, this.showICame, this.showRuntime, false, this.cbShowPosition.isSelected()){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                PersonListTopComponent.this.reloadList();
            }
        };
        AbstractNode abstractNode = this.createAbstractRootNode(personChildFactory, ImageUtilities.loadImage((String)"icons/persons.png"));
        LOG.fine("going to set root context person list- " + Duration.between(LocalDateTime.now(), now).toString() + " - " + persons.size() + " elements");
        em.setRootContext((Node)abstractNode);
        em.getRootContext().setDisplayName("Persons [" + persons.size() + "]");
        this.setName(Bundle.CTL_PersonListTopComponent() + " [" + persons.size() + "]");
        LOG.fine("finished set root context person list- " + Duration.between(LocalDateTime.now(), now).toString());
    }

    private <T extends ChildFactory> AbstractNode createAbstractRootNode(T childFactory, final Image img) {
        AbstractNode abstractNode = new AbstractNode(Children.create(childFactory, (boolean)false)){

            public Action[] getActions(boolean context) {
                ArrayList<Object> list = new ArrayList<Object>();
                if (PersonListTopComponent.this.db.getScenerixxSettings().isShowImport()) {
                    list.add(SystemAction.get(ShowAvailableScenerixxFilesAction.class));
                }
                if (PersonListTopComponent.this.db.getScenerixxSettings().isShowRare()) {
                    list.add(SystemAction.get(ShowOnlyPersonsWithoutScenerixxFileAction.class));
                }
                if (PersonListTopComponent.this.db.getScenerixxSettings().isShowImport()) {
                    list.add(SystemAction.get(ImportPersonAction.class));
                }
                ReloadPersonsAction reloadAction = (ReloadPersonsAction)SystemAction.get(ReloadPersonsAction.class);
                if (PersonListTopComponent.this.showScenerixxFiles) {
                    reloadAction.setName("Reload to show persons from database");
                } else {
                    reloadAction.setName("Reload");
                }
                list.add((Object)reloadAction);
                if (PersonListTopComponent.this.db.getScenerixxSettings().isShowExport()) {
                    list.add(SystemAction.get(ExportAllPersonsAction.class));
                }
                Action[] actions = new Action[list.size()];
                actions = list.toArray(actions);
                return actions;
            }

            public Image getIcon(int type) {
                return img;
            }

            public Image getOpenedIcon(int type) {
                return this.getIcon(type);
            }
        };
        return abstractNode;
    }

    private void setRootContextRemindsMeOf(List<Person> remindsMeOfPersons) {
        RemindsMeOfChildFactory remindsMeOfChildFactory = new RemindsMeOfChildFactory(remindsMeOfPersons, this.cbShowCounter.isSelected(), this.showBirthyear, this.showRating, this.showICame, this.showRuntime, false){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                PersonListTopComponent.this.reloadList();
            }
        };
        AbstractNode abstractNode = this.createAbstractRootNode(remindsMeOfChildFactory, ImageUtilities.loadImage((String)"icons/persons.png"));
        em.setRootContext((Node)abstractNode);
        em.getRootContext().setDisplayName("Persons [" + remindsMeOfPersons.size() + "]");
    }

    private void setRootContextHairColor(Gender gender) {
        HairColorChildFactory hairColorChildFactory = new HairColorChildFactory(gender, this.cbShowCounter.isSelected(), this.showBirthyear, this.showRating, this.showICame, this.showRuntime, Scenerixx.unlocked, this.cbShowPosition.isSelected()){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                PersonListTopComponent.this.reloadList();
            }
        };
        AbstractNode abstractNode = this.createAbstractRootNode(hairColorChildFactory, ImageUtilities.loadImage((String)"icons/persons.png"));
        em.setRootContext((Node)abstractNode);
        em.getRootContext().setDisplayName("Hair colors [" + HairColor.values().length + "]");
    }

    private void setRootContextBodyType(Gender gender) {
        BodyTypeChildFactory bodyTypeChildFactory = new BodyTypeChildFactory(gender, this.cbShowCounter.isSelected(), this.showBirthyear, this.showRating, this.showICame, this.showRuntime, Scenerixx.unlocked, this.cbShowPosition.isSelected()){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                PersonListTopComponent.this.reloadList();
            }
        };
        AbstractNode abstractNode = this.createAbstractRootNode(bodyTypeChildFactory, ImageUtilities.loadImage((String)"icons8/plastic-surgery.png"));
        em.setRootContext((Node)abstractNode);
        em.getRootContext().setDisplayName("Body Types [" + BodyType.values().length + "]");
    }

    private void setRootContextAppearance(Gender gender) {
        AppearanceChildFactory appearanceChildFactory = new AppearanceChildFactory(gender, this.cbShowCounter.isSelected(), this.showBirthyear, this.showRating, this.showICame, this.showRuntime, Scenerixx.unlocked, this.cbShowPosition.isSelected()){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                PersonListTopComponent.this.reloadList();
            }
        };
        AbstractNode abstractNode = this.createAbstractRootNode(appearanceChildFactory, ImageUtilities.loadImage((String)"icons.silk/user_orange.png"));
        em.setRootContext((Node)abstractNode);
        em.getRootContext().setDisplayName("Appearances [" + Appearance.values().length + "]");
    }

    private void setRootContextEthnicity(Gender gender) {
        EthnicityChildFactory ethnicityChildFactory = new EthnicityChildFactory(gender, this.cbShowCounter.isSelected(), this.showBirthyear, this.showRating, this.showICame, this.showRuntime, Scenerixx.unlocked, this.cbShowPosition.isSelected()){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                PersonListTopComponent.this.reloadList();
            }
        };
        AbstractNode abstractNode = this.createAbstractRootNode(ethnicityChildFactory, ImageUtilities.loadImage((String)"icons/People.png"));
        em.setRootContext((Node)abstractNode);
        em.getRootContext().setDisplayName("Ethnicity [" + Ethnicity.values().length + "]");
    }

    private void setRootContextNationality(Gender gender) {
        NationalityChildFactory nationalityChildFactory = new NationalityChildFactory(gender, this.cbShowCounter.isSelected(), this.showBirthyear, this.showRating, this.showICame, this.showRuntime, Scenerixx.unlocked, this.cbShowPosition.isSelected()){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                PersonListTopComponent.this.reloadList();
            }
        };
        AbstractNode abstractNode = this.createAbstractRootNode(nationalityChildFactory, ImageUtilities.loadImage((String)"icons/People.png"));
        em.setRootContext((Node)abstractNode);
        em.getRootContext().setDisplayName("Nationality [" + nationalityChildFactory.getTotalPeople() + " persons in " + abstractNode.getChildren().getNodesCount() + " nations]");
    }

    private void setRootContextBodyPartSize(Gender gender, BodyPart bodyPart) {
        BodyPartSizeChildFactory bodyPartSizeChildFactory = new BodyPartSizeChildFactory(gender, this.cbShowCounter.isSelected(), this.showBirthyear, this.showRating, this.showICame, this.showRuntime, Scenerixx.unlocked, this.cbShowPosition.isSelected(), bodyPart){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                PersonListTopComponent.this.reloadList();
            }
        };
        AbstractNode abstractNode = this.createAbstractRootNode(bodyPartSizeChildFactory, ImageUtilities.loadImage((String)"icons/femaleperson.png"));
        em.setRootContext((Node)abstractNode);
        em.getRootContext().setDisplayName(String.valueOf(bodyPart) + " Size [" + BodyPartSize.values().length + "]");
    }

    public void reloadListBirthday() {
        List<Person> birthdayPersons = new ArrayList();
        if (OrderByGender.All.equals(this.comboOrderByGender.getSelectedItem())) {
            birthdayPersons = this.db.getPersonsByBirthdate(null, Scenerixx.unlocked);
        } else if (OrderByGender.Female.equals(this.comboOrderByGender.getSelectedItem())) {
            birthdayPersons = this.db.getPersonsByBirthdate(Gender.FEMALE, Scenerixx.unlocked);
        } else if (OrderByGender.Male.equals(this.comboOrderByGender.getSelectedItem())) {
            birthdayPersons = this.db.getPersonsByBirthdate(Gender.MALE, Scenerixx.unlocked);
        } else if (OrderByGender.TS.equals(this.comboOrderByGender.getSelectedItem())) {
            birthdayPersons = this.db.getPersonsByBirthdate(Gender.TS, Scenerixx.unlocked);
        } else if (OrderByGender.AllTimeFavourites.equals(this.comboOrderByGender.getSelectedItem())) {
            birthdayPersons = this.db.getAllTimeFavoritePersons();
        } else if (OrderByGender.OnlyFavourites.equals(this.comboOrderByGender.getSelectedItem())) {
            birthdayPersons = this.db.getFavoritePersons(this.cbShowAliases.isSelected(), this.tfSearch.getText(), Scenerixx.unlocked);
        } else if (OrderByGender.RemindsMeOf.equals(this.comboOrderByGender.getSelectedItem())) {
            AbstractTopComponent.notifyInfo("The combination of 'Reminds me of' and 'Birthday' is not available");
        }
        Date today = new Date();
        today.setHours(0);
        today.setMinutes(0);
        today.setSeconds(0);
        for (Person p : birthdayPersons) {
            if (today.getMonth() + 1 > p.getBirthMonth() || p.getBirthDay() == null || p.getBirthDay() != null && p.getBirthDay() < today.getDate()) continue;
            Collections.rotate(birthdayPersons, -1 * birthdayPersons.indexOf(p));
            break;
        }
        this.setRootContextBirthday(birthdayPersons);
    }

    private void setRootContextBirthday(List<Person> persons) {
        PersonChildFactory personChildFactory = new PersonChildFactory(persons, false, false, false, false, false, true, true, true, true){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                PersonListTopComponent.this.reloadListBirthday();
            }
        };
        AbstractNode abstractNode = this.createAbstractRootNode(personChildFactory, ImageUtilities.loadImage((String)"icons/Gift.png"));
        em.setRootContext((Node)abstractNode);
        String displayname = "Birthdays [" + persons.size() + "] ";
        em.getRootContext().setDisplayName(displayname);
    }

    public void appendSearchText(String s) {
        String current = this.tfSearch.getText();
        if (current.isEmpty()) {
            this.tfSearch.setText(s);
        } else {
            this.tfSearch.setText(current + ", " + s);
        }
    }

    public void setNodeValue(Person p) {
        for (Node n : em.getSelectedNodes()) {
            n.setValue("person", (Object)p);
        }
    }

    public JTextField getTfSearch() {
        return this.tfSearch;
    }

    public class UpdateSearchResultListWorker
    extends SwingWorker<String, String> {
        @Override
        protected String doInBackground() throws Exception {
            String org = new String(PersonListTopComponent.this.tfSearch.getText());
            Thread.sleep(100L);
            if (PersonListTopComponent.this.tfSearch.getText().equals(org)) {
                Thread.sleep(500L);
                if (PersonListTopComponent.this.tfSearch.getText().equals(org)) {
                    LOG.fine("Searchterms: " + PersonListTopComponent.this.tfSearch.getText());
                    PersonListTopComponent.this.reloadList();
                    SearchQuery sq = new SearchQuery();
                    sq.setSearchQuery(PersonListTopComponent.this.tfSearch.getText());
                    sq.setTab(Tab.Persons);
                    PersonListTopComponent.this.db.getEntityService().save((AbstractEntity)sq);
                }
            }
            return "";
        }
    }
}

