/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.person.action;

import java.awt.Image;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.xml.transform.TransformerException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;
import xxx.scenerixx.scenerixxlib.db.DB;
import xxx.scenerixx.scenerixxlib.exporter.Exporter;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.windows.person.PersonListTopComponent;

public class ExportAllPersonsAction
extends NodeAction
implements Presenter.Popup {
    private DB db = DB.getInstance();

    public ExportAllPersonsAction() {
        Image image = ImageUtilities.loadImage((String)"icons/Upload.png");
        this.putValue("SmallIcon", image);
    }

    protected void performAction(Node[] selectedNodes) {
        int i = 0;
        for (Person p : this.db.getPersons(Scenerixx.unlocked)) {
            Exporter exp = new Exporter();
            String exportFile = "";
            try {
                exportFile = exp.exportPersonToFile(p, Scenerixx.getPathToPersonExport(p), false);
                ++i;
            }
            catch (TransformerException ex) {
                JOptionPane.showMessageDialog(null, "An error occured while exporting '" + p.getName() + "' to " + exportFile + ". Does the destination exists?\nThe error message we received: " + ex.getMessageAndLocation());
            }
            PersonListTopComponent.LOG.info("Exported " + p.getName() + " to " + exportFile);
        }
        JOptionPane.showMessageDialog(null, "Exported " + i + " persons");
    }

    protected boolean enable(Node[] activatedNodes) {
        return true;
    }

    public String getName() {
        return "Export All Persons From Database";
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public JMenuItem getPopupPresenter() {
        return new JMenuItem((Action)((Object)this));
    }

    protected boolean asynchronous() {
        return false;
    }
}

