/*
 * Decompiled with CFR 0.152.
 */
package xxx.scenerixx.scenerixxmodule.windows.playlist;

import com.querydsl.core.types.dsl.EntityPathBase;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyVetoException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import xxx.scenerixx.scenerixxlib.model.AbstractEntity;
import xxx.scenerixx.scenerixxlib.model.Bookmark;
import xxx.scenerixx.scenerixxlib.model.IPlayable;
import xxx.scenerixx.scenerixxlib.model.IPlayablePlaylistItems;
import xxx.scenerixx.scenerixxlib.model.Movie;
import xxx.scenerixx.scenerixxlib.model.Person;
import xxx.scenerixx.scenerixxlib.model.Scene;
import xxx.scenerixx.scenerixxlib.model.Studio;
import xxx.scenerixx.scenerixxlib.model.enums.gui.ShowHideMovieFilter;
import xxx.scenerixx.scenerixxlib.model.medium.MediumFile;
import xxx.scenerixx.scenerixxlib.model.playlist.Playlist;
import xxx.scenerixx.scenerixxlib.model.playlist.PlaylistEntry;
import xxx.scenerixx.scenerixxlib.model.settings.QUiState;
import xxx.scenerixx.scenerixxlib.model.settings.UiState;
import xxx.scenerixx.scenerixxmodule.Scenerixx;
import xxx.scenerixx.scenerixxmodule.childfactories.playlist.PlaylistChildFactory;
import xxx.scenerixx.scenerixxmodule.childfactories.playlistentry.action.OpenSeveralInstancesAction;
import xxx.scenerixx.scenerixxmodule.util.ScenerixxCommon;
import xxx.scenerixx.scenerixxmodule.util.gui.bean.ScenerixxBeanTreeView;
import xxx.scenerixx.scenerixxmodule.windows.AbstractTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.dashboard.DashboardTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.movie.MovieListTopComponent;
import xxx.scenerixx.scenerixxmodule.windows.playlist.Bundle;
import xxx.scenerixx.scenerixxmodule.windows.playlist.action.CreatePlaylistAction;
import xxx.scenerixx.scenerixxmodule.windows.playlist.action.ReloadPlaylistAction;

@TopComponent.Description(preferredID="PlaylistTopComponent", iconBase="icons/notes.png", persistenceType=0)
public final class PlaylistTopComponent
extends AbstractTopComponent
implements ExplorerManager.Provider {
    public static final Logger LOG = Logger.getLogger(PlaylistTopComponent.class.getName());
    private static final ExplorerManager em = new ExplorerManager();
    private boolean initialized = false;
    private List<Playlist> playlists;
    private boolean asc = true;
    private final ScenerixxCommon scenerixxCommon = new ScenerixxCommon();
    private BeanTreeView beanTreeView1;
    private JButton btnDeletePlaylist;
    private ButtonGroup btnGrpOrderBy;
    private JButton btnNew;
    private JButton btnOpen;
    private JButton btnOpenRandomized;
    private JButton btnReload;
    private JButton btnReload1;
    private JButton btnSelectRandomized;
    private JCheckBox cbShowArchived;
    public JCheckBox cbShowPosition;
    private JCheckBox cbShowTimeAndEntries;
    private JLabel lbOrderBy;
    private JLabel lbStatus;
    public JRadioButton rbOrderByDateOfCreation;
    public JRadioButton rbOrderByName;
    public JToggleButton toggleBtnAsc;

    public PlaylistTopComponent() {
        LOG.info("Initialize Playlist window");
        WindowManager.getDefault().invokeWhenUIReady(() -> {
            StatusDisplayer.getDefault().setStatusText("Initializing Playlist window");
            TopComponent dashboard = WindowManager.getDefault().findTopComponent("DashboardTopComponent");
            if (dashboard != null) {
                ((DashboardTopComponent)dashboard).setStatus("Initializing Playlist window");
            }
        });
        this.initComponents();
        this.setName(Bundle.CTL_PlaylistTopComponent());
        this.setToolTipText(Bundle.HINT_PlaylistTopComponent());
        Image image = ImageUtilities.loadImage((String)"icons.fatcow/vlc.png");
        image = ImageUtilities.mergeImages((Image)image, (Image)ImageUtilities.loadImage((String)"icons.fatcow/dice.png"), (int)4, (int)4);
        this.btnOpenRandomized.setIcon(ImageUtilities.image2Icon((Image)image));
        UiState uiState = (UiState)this.db.getEntityService().find((EntityPathBase)QUiState.uiState).findFirst();
        if (uiState == null) {
            uiState = new UiState();
        }
        this.toggleBtnAsc.setSelected(uiState.isPlaylistAsc());
        this.cbShowPosition.setSelected(uiState.isPlaylistShowPosition());
        this.toggleShowPosition();
        this.toggleShowTimeAndEntries();
        this.toggleShowArchived();
        this.rbOrderByDateOfCreation.setSelected(uiState.isPlaylistOrderByCreation());
        this.rbOrderByName.setSelected(uiState.isPlaylistOrderByName());
        this.toggleOrderBy();
        this.asc = uiState.isPlaylistAsc();
        this.toggleAsc();
        this.setDirty();
        this.initialized = true;
        em.addPropertyChangeListener(evt -> {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                Node[] selectedNodes = em.getSelectedNodes();
                ScenerixxCommon.setSelectedNodesInTitle(selectedNodes.length, "playlist(entry)");
            }
            if (em.getSelectedNodes().length == 1 && em.getSelectedNodes()[0].getValue("entry") != null) {
                PlaylistEntry pe = (PlaylistEntry)em.getSelectedNodes()[0].getValue("entry");
                MovieListTopComponent movieList = (MovieListTopComponent)WindowManager.getDefault().findTopComponent("MovieListTopComponent");
                Movie movie = pe.getMovie();
                Scene scene = pe.getScene();
                if (pe.getBookmark() != null) {
                    movie = pe.getBookmark().getMovie();
                }
                if (movieList != null && movie != null) {
                    movieList.selectMovieNode(movie);
                }
                if (movieList != null && scene != null) {
                    LOG.info("Reload details for scene");
                    this.reloadDetails(scene);
                    LOG.info("Reloaded");
                    movieList.selectSceneNode(scene);
                }
            }
            this.btnDeletePlaylist.setEnabled(false);
            if (em.getSelectedNodes().length >= 1) {
                for (PlaylistEntry n : em.getSelectedNodes()) {
                    if (n.getValue("playlist") == null) continue;
                    this.btnDeletePlaylist.setEnabled(true);
                    break;
                }
            }
            this.btnOpen.setEnabled(false);
            this.btnOpenRandomized.setEnabled(false);
            this.btnSelectRandomized.setEnabled(false);
            if (em.getSelectedNodes().length == 1) {
                this.btnSelectRandomized.setEnabled(true);
                if (em.getSelectedNodes()[0].getValue("playlist") != null) {
                    this.btnOpen.setEnabled(true);
                    this.btnOpenRandomized.setEnabled(true);
                } else if (em.getSelectedNodes()[0].getValue("entry") != null) {
                    this.btnOpen.setEnabled(true);
                    this.btnOpenRandomized.setEnabled(false);
                }
            } else if (em.getSelectedNodes().length > 1 && em.getSelectedNodes()[0].getValue("entry") != null) {
                boolean allEntries = true;
                for (Node n : em.getSelectedNodes()) {
                    if (n.getValue("entry") != null && n.getValue("entry") instanceof PlaylistEntry) continue;
                    allEntries = false;
                }
                this.btnOpen.setEnabled(allEntries);
                this.btnOpenRandomized.setEnabled(allEntries);
            }
        });
        KeyStroke keyDelete = KeyStroke.getKeyStroke(127, 0);
        AbstractAction performDelete = new AbstractAction("performDelete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlaylistTopComponent.this.deletePlaylistsAndEntries();
            }
        };
        this.beanTreeView1.getActionMap().put("performDelete", performDelete);
        this.beanTreeView1.getInputMap(1).put(keyDelete, "performDelete");
        KeyStroke keyEnter = KeyStroke.getKeyStroke(10, 2);
        AbstractAction openSelectedItems = new AbstractAction("OpenSelectedItemsFromPlaylist"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlaylistTopComponent.this.openPlaylist(false);
            }
        };
        this.beanTreeView1.getActionMap().put("OpenSelectedItemsFromPlaylist", openSelectedItems);
        this.beanTreeView1.getInputMap(1).put(keyEnter, "OpenSelectedItemsFromPlaylist");
        KeyStroke keyRename = KeyStroke.getKeyStroke(118, 0);
        AbstractAction performRename = new AbstractAction("Rename"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlaylistTopComponent.this.renamePlaylist();
            }
        };
        this.beanTreeView1.getActionMap().put("performRename", performRename);
        this.beanTreeView1.getInputMap(1).put(keyRename, "performRename");
        AbstractAction reloadAction = new AbstractAction("reload"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlaylistTopComponent.this.reloadList();
            }
        };
        KeyStroke keyF5 = KeyStroke.getKeyStroke(116, 0);
        this.beanTreeView1.getActionMap().put("reload", reloadAction);
        this.beanTreeView1.getInputMap(1).put(keyF5, "reload");
        KeyStroke keyAddPersonFromClipboard = KeyStroke.getKeyStroke(10, 192);
        this.beanTreeView1.getActionMap().put("OpenSeveralInstances", (Action)SystemAction.get(OpenSeveralInstancesAction.class));
        this.beanTreeView1.getInputMap(1).put(keyAddPersonFromClipboard, "OpenSeveralInstances");
        KeyStroke keyF6 = KeyStroke.getKeyStroke(117, 0);
        AbstractAction performAddToClipboard = new AbstractAction("performAddToClipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOG.info("copy to temp playlist");
                int movie = 0;
                int scene = 0;
                int bookmark = 0;
                String displayname = "";
                if (em.getSelectedNodes().length > 0) {
                    for (Node n : em.getSelectedNodes()) {
                        Object object;
                        if (n.getValue("entry") == null || !((object = n.getValue("entry")) instanceof PlaylistEntry)) continue;
                        PlaylistEntry pe = (PlaylistEntry)object;
                        if (pe.getMovie() != null) {
                            PlaylistTopComponent.this.clipboard((IPlayablePlaylistItems)pe.getMovie());
                            displayname = pe.getMovie().getNameOfPlayable();
                            ++movie;
                        }
                        if (pe.getScene() != null) {
                            PlaylistTopComponent.this.clipboard((IPlayablePlaylistItems)pe.getScene());
                            displayname = pe.getScene().getNameOfPlayable();
                            ++scene;
                        }
                        if (pe.getBookmark() == null) continue;
                        PlaylistTopComponent.this.clipboard((IPlayablePlaylistItems)pe.getBookmark());
                        displayname = pe.getBookmark().getNameOfPlayable();
                        ++bookmark;
                    }
                    if (movie + scene + bookmark == 1) {
                        AbstractTopComponent.notifyInfo("added to temporary playlist: " + displayname);
                        LOG.info("added to temporary playlist: " + displayname);
                    } else {
                        AbstractTopComponent.notifyInfo("added to temporary playlist: " + ScenerixxCommon.singularPlural(movie, "movie", true) + ", " + ScenerixxCommon.singularPlural(scene, "scene", true) + ", " + ScenerixxCommon.singularPlural(bookmark, "bookmark", true));
                        LOG.info("added to temporary playlist: " + ScenerixxCommon.singularPlural(movie, "movie", true) + ", " + ScenerixxCommon.singularPlural(scene, "scene", true) + ", " + ScenerixxCommon.singularPlural(bookmark, "bookmark", true));
                    }
                    AbstractTopComponent.reloadPlaylist("[TEMPORARY PLAYLIST]");
                }
            }
        };
        this.beanTreeView1.getActionMap().put("performAddToClipboard", performAddToClipboard);
        this.beanTreeView1.getInputMap(1).put(keyF6, "performAddToClipboard");
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)em, (ActionMap)this.getActionMap()));
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void initComponents() {
        this.btnGrpOrderBy = new ButtonGroup();
        this.beanTreeView1 = new ScenerixxBeanTreeView();
        this.btnDeletePlaylist = new JButton();
        this.rbOrderByName = new JRadioButton();
        this.rbOrderByDateOfCreation = new JRadioButton();
        this.btnOpen = new JButton();
        this.btnOpenRandomized = new JButton();
        this.btnNew = new JButton();
        this.cbShowPosition = new JCheckBox();
        this.toggleBtnAsc = new JToggleButton();
        this.lbOrderBy = new JLabel();
        this.lbStatus = new JLabel();
        this.btnReload = new JButton();
        this.btnSelectRandomized = new JButton();
        this.cbShowTimeAndEntries = new JCheckBox();
        this.cbShowArchived = new JCheckBox();
        this.btnReload1 = new JButton();
        this.btnDeletePlaylist.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Erase.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnDeletePlaylist, (String)NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.btnDeletePlaylist.text"));
        this.btnDeletePlaylist.setEnabled(false);
        this.btnDeletePlaylist.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaylistTopComponent.this.btnDeletePlaylistActionPerformed(evt);
            }
        });
        this.btnGrpOrderBy.add(this.rbOrderByName);
        Mnemonics.setLocalizedText((AbstractButton)this.rbOrderByName, (String)NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.rbOrderByName.text"));
        this.rbOrderByName.setToolTipText(NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.rbOrderByName.toolTipText"));
        this.rbOrderByName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaylistTopComponent.this.rbOrderByNameActionPerformed(evt);
            }
        });
        this.btnGrpOrderBy.add(this.rbOrderByDateOfCreation);
        this.rbOrderByDateOfCreation.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbOrderByDateOfCreation, (String)NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.rbOrderByDateOfCreation.text"));
        this.rbOrderByDateOfCreation.setToolTipText(NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.rbOrderByDateOfCreation.toolTipText"));
        this.rbOrderByDateOfCreation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaylistTopComponent.this.rbOrderByDateOfCreationActionPerformed(evt);
            }
        });
        this.btnOpen.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/vlc.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpen, (String)NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.btnOpen.text"));
        this.btnOpen.setEnabled(false);
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaylistTopComponent.this.btnOpenActionPerformed(evt);
            }
        });
        this.btnOpenRandomized.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/vlc.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnOpenRandomized, (String)NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.btnOpenRandomized.text"));
        this.btnOpenRandomized.setEnabled(false);
        this.btnOpenRandomized.setToolTipText(NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.btnOpenRandomized.toolTipText"));
        this.btnOpenRandomized.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaylistTopComponent.this.btnOpenRandomizedActionPerformed(evt);
            }
        });
        this.btnNew.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Add.gif")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnNew, (String)NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.btnNew.text"));
        this.btnNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaylistTopComponent.this.btnNewActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowPosition, (String)NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.cbShowPosition.text"));
        this.cbShowPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaylistTopComponent.this.cbShowPositionActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.toggleBtnAsc, (String)NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.toggleBtnAsc.text"));
        this.toggleBtnAsc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaylistTopComponent.this.toggleBtnAscActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lbOrderBy, (String)NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.lbOrderBy.text"));
        Mnemonics.setLocalizedText((JLabel)this.lbStatus, (String)NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.lbStatus.text"));
        this.btnReload.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReload, (String)NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.btnReload.text"));
        this.btnReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaylistTopComponent.this.btnReloadActionPerformed(evt);
            }
        });
        this.btnSelectRandomized.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/dice.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnSelectRandomized, (String)NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.btnSelectRandomized.text"));
        this.btnSelectRandomized.setEnabled(false);
        this.btnSelectRandomized.setToolTipText(NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.btnSelectRandomized.toolTipText"));
        this.btnSelectRandomized.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaylistTopComponent.this.btnSelectRandomizedActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowTimeAndEntries, (String)NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.cbShowTimeAndEntries.text"));
        this.cbShowTimeAndEntries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaylistTopComponent.this.cbShowTimeAndEntriesActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbShowArchived, (String)NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.cbShowArchived.text"));
        this.cbShowArchived.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaylistTopComponent.this.cbShowArchivedActionPerformed(evt);
            }
        });
        this.btnReload1.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons/Refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btnReload1, (String)NbBundle.getMessage(PlaylistTopComponent.class, (String)"PlaylistTopComponent.btnReload1.text"));
        this.btnReload1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PlaylistTopComponent.this.btnReload1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(3, 3, 3).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.beanTreeView1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lbOrderBy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbOrderByDateOfCreation).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbOrderByName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.toggleBtnAsc)).addGroup(layout.createSequentialGroup().addComponent(this.cbShowPosition).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowTimeAndEntries).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowArchived))).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnReload1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOpen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSelectRandomized).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnOpenRandomized).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnDeletePlaylist)).addGroup(layout.createSequentialGroup().addComponent(this.lbStatus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnReload))).addGap(0, 135, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOpen).addComponent(this.btnOpenRandomized).addComponent(this.btnDeletePlaylist).addComponent(this.btnNew).addComponent(this.btnSelectRandomized).addComponent(this.btnReload1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lbStatus).addComponent(this.btnReload)).addGap(9, 9, 9).addComponent((Component)this.beanTreeView1, -1, 222, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.rbOrderByDateOfCreation).addComponent(this.rbOrderByName).addComponent(this.toggleBtnAsc).addComponent(this.lbOrderBy)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbShowPosition).addComponent(this.cbShowTimeAndEntries).addComponent(this.cbShowArchived))));
    }

    private void btnDeletePlaylistActionPerformed(ActionEvent evt) {
        this.deletePlaylistsAndEntries();
    }

    private void rbOrderByDateOfCreationActionPerformed(ActionEvent evt) {
        this.toggleOrderBy();
    }

    private void rbOrderByNameActionPerformed(ActionEvent evt) {
        this.toggleOrderBy();
    }

    private void toggleOrderBy() {
        if (this.rbOrderByDateOfCreation.isSelected()) {
            this.rbOrderByDateOfCreation.setIcon(ImageUtilities.loadImageIcon((String)"icons.silkcompanion/new_blue.png", (boolean)false));
        } else {
            this.rbOrderByDateOfCreation.setIcon(null);
        }
        if (this.rbOrderByName.isSelected()) {
            this.rbOrderByName.setIcon(ImageUtilities.loadImageIcon((String)"icons.silk/font.png", (boolean)false));
        } else {
            this.rbOrderByName.setIcon(null);
        }
        this.reloadAndSelect();
    }

    private void reloadAndSelect() {
        if (em.getSelectedNodes().length == 1) {
            this.reloadList(em.getSelectedNodes()[0]);
        } else {
            this.reloadList();
        }
    }

    private void btnOpenActionPerformed(ActionEvent evt) {
        this.openPlaylist(false);
    }

    private void btnOpenRandomizedActionPerformed(ActionEvent evt) {
        this.openPlaylist(true);
    }

    private void btnNewActionPerformed(ActionEvent evt) {
        this.createNewPlaylist();
    }

    private void cbShowPositionActionPerformed(ActionEvent evt) {
        this.toggleShowPosition();
    }

    private void toggleShowPosition() {
        if (this.cbShowPosition.isSelected()) {
            this.cbShowPosition.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/text_list_numbers.png")));
        } else {
            this.cbShowPosition.setIcon(null);
        }
        this.reloadAndSelect();
    }

    private void toggleShowTimeAndEntries() {
        if (this.cbShowTimeAndEntries.isSelected()) {
            this.cbShowTimeAndEntries.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/clock_add.png")));
        } else {
            this.cbShowTimeAndEntries.setIcon(null);
        }
        this.reloadAndSelect();
    }

    private void toggleShowArchived() {
        if (this.cbShowArchived.isSelected()) {
            this.cbShowArchived.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/bookshelf.png")));
        } else {
            this.cbShowArchived.setIcon(null);
        }
        this.reloadAndSelect();
    }

    private void toggleBtnAscActionPerformed(ActionEvent evt) {
        this.toggleAsc();
    }

    private void btnReloadActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private void btnSelectRandomizedActionPerformed(ActionEvent evt) {
        this.selectRandomNode();
    }

    private void cbShowTimeAndEntriesActionPerformed(ActionEvent evt) {
        this.toggleShowTimeAndEntries();
    }

    private void cbShowArchivedActionPerformed(ActionEvent evt) {
        this.toggleShowArchived();
    }

    private void btnReload1ActionPerformed(ActionEvent evt) {
        this.reloadList();
    }

    private Node selectRandomNode() {
        Node selectedNode = null;
        if (em.getSelectedNodes().length > 0) {
            selectedNode = em.getSelectedNodes()[0];
            Random rnd = new Random();
            boolean playlislistentry = false;
            boolean playlist = false;
            if (selectedNode.getValue("entry") != null) {
                playlislistentry = true;
                LOG.info("playlist entry is selected");
            }
            if (selectedNode.getValue("playlist") != null) {
                playlist = true;
                LOG.info("playlist is selected");
            }
            boolean notfound = true;
            int counter = 0;
            while (notfound) {
                ++counter;
                int nextIntPlaylist = rnd.nextInt(em.getRootContext().getChildren().getNodesCount());
                Node randomChild = null;
                if (playlislistentry) {
                    try {
                        int playlistentrysize = ((PlaylistEntry)selectedNode.getValue("entry")).getPlaylist().getEntries(Scenerixx.unlocked).size();
                        LOG.finer("selectedNode.getChildren().getNodesCount() " + selectedNode.getChildren().getNodesCount());
                        LOG.finer("playlistentrysize " + playlistentrysize);
                        em.setSelectedNodes(new Node[]{selectedNode.getParentNode()});
                        selectedNode = em.getSelectedNodes()[0];
                        int nextIntPlaylistEntry = rnd.nextInt(selectedNode.getChildren().getNodesCount());
                        randomChild = selectedNode.getChildren().getNodeAt(nextIntPlaylistEntry);
                    }
                    catch (PropertyVetoException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    randomChild = em.getRootContext().getChildren().getNodeAt(nextIntPlaylist);
                }
                try {
                    LOG.info("Counter: " + counter + " - playlist: " + playlist + " - PE: " + playlislistentry + " - random node: " + String.valueOf(randomChild));
                    if (!(playlislistentry && randomChild.getValue("entry") != null || playlist && randomChild.getValue("playlist") != null) && counter <= 500) continue;
                    try {
                        em.setSelectedNodes(new Node[]{randomChild});
                        selectedNode = randomChild;
                    }
                    catch (PropertyVetoException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    notfound = false;
                }
                catch (IllegalArgumentException iae) {
                    LOG.severe(iae.getMessage() + " - nodesCount: " + randomChild.getChildren().getNodesCount());
                }
            }
        }
        return selectedNode;
    }

    private void toggleAsc() {
        this.toggleBtnAsc.setText("");
        boolean bl = this.asc = !this.asc;
        if (this.asc) {
            this.toggleBtnAsc.setToolTipText("sort ascending");
            this.toggleBtnAsc.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/sort_ascending.png")));
        } else {
            this.toggleBtnAsc.setToolTipText("sort descending");
            this.toggleBtnAsc.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/icons.fatcow/sort_descending.png")));
        }
        this.reloadList();
    }

    public void openPlaylist(boolean randomized) {
        MovieListTopComponent movieList = (MovieListTopComponent)WindowManager.getDefault().findTopComponent("MovieListTopComponent");
        if (movieList != null && em.getSelectedNodes().length == 1) {
            Playlist playlist = (Playlist)em.getSelectedNodes()[0].getValue("playlist");
            PlaylistEntry pe = (PlaylistEntry)em.getSelectedNodes()[0].getValue("entry");
            if (playlist != null) {
                movieList.openVlcPlaylist("Playlist " + playlist.getName(), playlist, randomized);
            } else if (pe != null) {
                if (pe.getBookmark() != null) {
                    movieList.openVlc(pe.getBookmark().getNameOfPlayable(), null, null, pe.getBookmark(), null, false);
                } else if (pe.getMovie() != null) {
                    movieList.openVlc(pe.getMovie().getNameOfPlayable(), pe.getMovie(), null, null, null, false);
                } else if (pe.getScene() != null) {
                    movieList.openVlc(pe.getScene().getNameOfPlayable(), null, pe.getScene(), null, null, false);
                } else if (pe.getMediumFile() != null) {
                    movieList.openVlc(pe.getMediumFile().getNameOfPlayable(), null, null, null, pe.getMediumFile(), false);
                }
            } else {
                AbstractTopComponent.notifyError("No playlist selected (or too many) that we can start");
            }
        } else {
            Playlist tmpPlaylist = new Playlist();
            for (Node n : em.getSelectedNodes()) {
                Object object;
                if (n.getValue("entry") == null || !((object = n.getValue("entry")) instanceof PlaylistEntry)) continue;
                PlaylistEntry pe = (PlaylistEntry)object;
                tmpPlaylist.getEntries(Scenerixx.unlocked).add(pe);
            }
            movieList.openVlc(tmpPlaylist, true, randomized);
        }
    }

    private void renamePlaylist() {
        int cntPlaylist = 0;
        for (Node n : em.getSelectedNodes()) {
            Playlist playlist = (Playlist)n.getValue("playlist");
            if (playlist == null) continue;
            ++cntPlaylist;
        }
        if (cntPlaylist == 1) {
            Playlist playlist = (Playlist)em.getSelectedNodes()[0].getValue("playlist");
            if (playlist.getId() != null) {
                playlist = (Playlist)this.db.getEntityService().load(Playlist.class, playlist.getId().longValue());
            }
            playlist = this.scenerixxCommon.renamePlaylist(playlist);
            this.reloadList(playlist.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void deletePlaylistsAndEntries() {
        int cntPlaylist = 0;
        int cntPlaylistEntries = 0;
        for (Node node : em.getSelectedNodes()) {
            PlaylistEntry entry;
            Playlist playlist = (Playlist)node.getValue("playlist");
            if (playlist != null && playlist.getId() == null) {
                ++cntPlaylist;
            }
            if (playlist != null && playlist.getId() != null) {
                playlist = (Playlist)this.db.getEntityService().load(Playlist.class, playlist.getId().longValue());
                ++cntPlaylist;
            }
            if ((entry = (PlaylistEntry)node.getValue("entry")) == null) continue;
            if (entry.getId() != null) {
                entry = (PlaylistEntry)this.db.getEntityService().load(PlaylistEntry.class, entry.getId().longValue());
                ++cntPlaylistEntries;
                continue;
            }
            LOG.info("before:E " + PlaylistTopComponent.getClipboard().size());
            int index = 0;
            boolean found = false;
            for (IPlayablePlaylistItems item : PlaylistTopComponent.getClipboard()) {
                if (item instanceof IPlayable && ((IPlayable)item).getNameOfPlayable().equalsIgnoreCase(entry.getNameOfPlayable())) {
                    found = true;
                    break;
                }
                ++index;
            }
            if (found) {
                PlaylistTopComponent.getClipboard().remove(index);
            }
            LOG.info("after:E " + PlaylistTopComponent.getClipboard().size());
            ++cntPlaylistEntries;
        }
        if (cntPlaylist > 0 || cntPlaylistEntries > 0) {
            Object msg = "Do you really want to delete ";
            if (cntPlaylist > 0 && cntPlaylistEntries == 0) {
                msg = (String)msg + ScenerixxCommon.singularPlural(cntPlaylist, "playlist", "playlists", true) + "?";
            } else if (cntPlaylist == 0 && cntPlaylistEntries > 0) {
                msg = (String)msg + ScenerixxCommon.singularPlural(cntPlaylistEntries, "playlist entry", "playlist entries", true) + "?";
            } else if (cntPlaylist > 0 && cntPlaylistEntries > 0) {
                msg = (String)msg + ScenerixxCommon.singularPlural(cntPlaylist, "playlist", "playlists", true) + " and " + ScenerixxCommon.singularPlural(cntPlaylistEntries, "playlist entry", "playlist entries", true) + "?";
            }
            if (0 == JOptionPane.showConfirmDialog(null, msg, "Delete Playlist(entries)?", 0)) {
                void var6_16;
                cntPlaylist = 0;
                cntPlaylistEntries = 0;
                Node nodeToSelect = null;
                ArrayList<PlaylistEntry> peList = new ArrayList<PlaylistEntry>();
                for (Node n : em.getSelectedNodes()) {
                    PlaylistEntry entry;
                    Playlist playlist = (Playlist)n.getValue("playlist");
                    if (playlist != null) {
                        if (playlist.getId() == null) {
                            PlaylistTopComponent.getClipboard().clear();
                        } else {
                            this.ps.deletePlaylist(playlist);
                        }
                        ++cntPlaylist;
                    }
                    if ((entry = (PlaylistEntry)n.getValue("entry")) == null) continue;
                    nodeToSelect = n.getParentNode();
                    peList.add(entry);
                    ++cntPlaylistEntries;
                }
                this.ps.deletePlaylistEntries(peList, true, Scenerixx.unlocked);
                this.reloadList(nodeToSelect);
                String string = "Deleted ";
                if (cntPlaylist > 0 && cntPlaylistEntries == 0) {
                    String string2 = string + ScenerixxCommon.singularPlural(cntPlaylist, "playlist", "playlists", true);
                }
                if (cntPlaylist == 0 && cntPlaylistEntries > 0) {
                    void var6_12;
                    String string3 = (String)var6_12 + ScenerixxCommon.singularPlural(cntPlaylistEntries, "playlist entry", "playlist entries", true);
                }
                if (cntPlaylist > 0 && cntPlaylistEntries > 0) {
                    void var6_14;
                    String string4 = (String)var6_14 + ScenerixxCommon.singularPlural(cntPlaylist, "playlist", "playlists", true) + " and " + ScenerixxCommon.singularPlural(cntPlaylistEntries, "playlist entry", "playlist entries", true);
                }
                AbstractTopComponent.notifyInfo((String)var6_16);
            }
        } else {
            AbstractTopComponent.notifyInfo("No playlist or playlist entry was selected. Nothing to delete.");
        }
    }

    public ExplorerManager getExplorerManager() {
        return em;
    }

    public void expandNode(Node n) {
        Node child = em.getRootContext().getChildren().findChild(n.getName());
        EventQueue.invokeLater(() -> this.beanTreeView1.expandNode(child));
    }

    public void reloadList(Node n) {
        SwingUtilities.invokeLater(() -> {
            block13: {
                LOG.info("reloading....");
                Node node = n;
                try {
                    if (node == null) {
                        this.reloadList();
                        break block13;
                    }
                    Node orgNode = node;
                    this.playlists = this.ps.getPlaylists(Scenerixx.unlocked, this.rbOrderByDateOfCreation.isSelected(), this.cbShowArchived.isSelected());
                    if (this.playlists != null) {
                        this.setRootContext(this.playlists);
                    }
                    Node child = em.getRootContext().getChildren().findChild(node.getName());
                    int i = 0;
                    while (child == null && (node = node.getParentNode()) != null) {
                        child = em.getRootContext().getChildren().findChild(node.getName());
                        ++i;
                    }
                    if (child != null) {
                        this.beanTreeView1.expandNode(child);
                        Node nodeToSelect = null;
                        if (i == 1) {
                            nodeToSelect = child.getChildren().findChild(orgNode.getName());
                        }
                        if (nodeToSelect != null) {
                            this.beanTreeView1.expandNode(orgNode);
                            node = orgNode;
                            try {
                                Node[] selectedNodes = new Node[]{nodeToSelect};
                                em.setSelectedNodes(selectedNodes);
                                this.beanTreeView1.expandNode(nodeToSelect);
                            }
                            catch (PropertyVetoException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
                            }
                        } else {
                            try {
                                nodeToSelect = em.getRootContext().getChildren().findChild(node.getName());
                                em.setSelectedNodes(new Node[]{nodeToSelect});
                                this.beanTreeView1.expandNode(nodeToSelect);
                            }
                            catch (PropertyVetoException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                                AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
                            }
                        }
                    }
                    this.scenerixxCommon.initPlaylistCache();
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
                }
            }
        });
    }

    public void reloadList() {
        if (!this.initialized) {
            LOG.fine("Still in initialization phase. Abort playlist list reload.");
            return;
        }
        LocalDateTime now = LocalDateTime.now();
        this.playlists = this.ps.getPlaylists(Scenerixx.unlocked, this.rbOrderByDateOfCreation.isSelected(), this.cbShowArchived.isSelected());
        if (this.playlists != null) {
            this.setRootContext(this.playlists);
            SwingUtilities.invokeLater(() -> {
                try {
                    LOG.info("reloadlist....");
                    boolean showPlaylists = false;
                    MovieListTopComponent movieList = (MovieListTopComponent)WindowManager.getDefault().findTopComponent("MovieListTopComponent");
                    if (movieList != null && ShowHideMovieFilter.ShowPlaylist.equals(movieList.comboShowHideFilter.getSelectedItem())) {
                        showPlaylists = true;
                    }
                    for (Node n : em.getRootContext().getChildren().getNodes(true)) {
                        Object patt0$temp;
                        if (n.getValue("playlist") == null || !((patt0$temp = n.getValue("playlist")) instanceof Playlist)) continue;
                        Playlist playlist = (Playlist)patt0$temp;
                        LOG.finer("show non default playlist: " + showPlaylists);
                        if ((!playlist.isDefaultPlaylist() || showPlaylists) && (!showPlaylists || movieList.getPlaylistToShow() == null || playlist.getId() == null || movieList.getPlaylistToShow().getId() == null || playlist.getId().longValue() != movieList.getPlaylistToShow().getId().longValue())) continue;
                        em.setSelectedNodes(new Node[]{n});
                        this.beanTreeView1.expandNode(n);
                        LOG.info("expanded: " + n.getName());
                        break;
                    }
                }
                catch (PropertyVetoException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    AbstractTopComponent.notifyError("An error occured: " + ex.getMessage());
                }
            });
            this.scenerixxCommon.initPlaylistCache();
            Duration between = Duration.between(now, LocalDateTime.now());
            if (between.getSeconds() >= 20L) {
                AbstractTopComponent.notifyWarning("The loading of the playlists took " + between.getSeconds() + " seconds. You might want to trim the history playlist (or any other longer list).");
            }
            this.resetDirtyState();
            LOG.info("Finished in " + between.getSeconds() + " seconds");
        }
    }

    private void resetDirtyState() {
        this.lbStatus.setText("");
        this.lbStatus.setVisible(false);
        this.btnReload.setVisible(false);
    }

    public void reloadList(String playlistName) {
        LocalDateTime now = LocalDateTime.now();
        this.playlists = this.ps.getPlaylists(Scenerixx.unlocked, this.rbOrderByDateOfCreation.isSelected(), this.cbShowArchived.isSelected());
        LOG.info("Fetched playlist in " + Duration.between(LocalDateTime.now(), now).toString());
        if (this.playlists != null) {
            this.setRootContext(this.playlists);
            LOG.info("set root context " + Duration.between(LocalDateTime.now(), now).toString());
            try {
                for (Node n : em.getRootContext().getChildren().getNodes(true)) {
                    Playlist playlist;
                    Object object;
                    if (n.getValue("playlist") == null || !((object = n.getValue("playlist")) instanceof Playlist) || !playlistName.equalsIgnoreCase((playlist = (Playlist)object).getName())) continue;
                    em.setSelectedNodes(new Node[]{n});
                    LOG.info("reloadlist....X");
                    this.beanTreeView1.expandNode(n);
                    break;
                }
            }
            catch (PropertyVetoException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                AbstractTopComponent.notifyError("An error occured while reloading playlists: " + ex.getMessage());
            }
            LOG.info("Selected node " + Duration.between(LocalDateTime.now(), now).toString());
            this.resetDirtyState();
        }
        this.scenerixxCommon.initPlaylistCache();
        LOG.info("Reloaded playlist " + playlistName + " in " + Duration.between(LocalDateTime.now(), now).toString());
    }

    private void setRootContext(List<Playlist> playlists) {
        if (!PlaylistTopComponent.getClipboard().isEmpty()) {
            Playlist tmpPlaylist = new Playlist();
            ArrayList<PlaylistEntry> tmpList = new ArrayList<PlaylistEntry>();
            int i = 0;
            for (IPlayablePlaylistItems p : PlaylistTopComponent.getClipboard()) {
                PlaylistEntry pe = new PlaylistEntry();
                pe.setPlaylist(tmpPlaylist);
                pe.setDateOfCreation(LocalDateTime.now());
                if (p instanceof Movie) {
                    Movie movie = (Movie)p;
                    pe.setMovie(movie);
                }
                if (p instanceof Scene) {
                    Scene scene = (Scene)p;
                    pe.setScene(scene);
                }
                if (p instanceof Bookmark) {
                    Bookmark bookmark = (Bookmark)p;
                    pe.setBookmark(bookmark);
                }
                if (p instanceof Person) {
                    Person person = (Person)p;
                    pe.setPerson(person);
                }
                if (p instanceof MediumFile) {
                    MediumFile mediumFile = (MediumFile)p;
                    pe.setMediumFile(mediumFile);
                }
                if (p instanceof Studio) {
                    Studio studio = (Studio)p;
                    pe.setStudio(studio);
                }
                pe.setPositionInList(i);
                pe.setPos(i);
                LOG.info(i + " - " + p.toString() + " --------------");
                ++i;
                tmpList.add(pe);
            }
            tmpPlaylist.setDateOfCreation(LocalDateTime.now());
            tmpPlaylist.setName("[TEMPORARY PLAYLIST]");
            tmpPlaylist.setEntries(tmpList);
            playlists.add(tmpPlaylist);
        }
        if (!this.asc) {
            Collections.reverse(playlists);
        }
        PlaylistChildFactory playlistChildFactory = new PlaylistChildFactory(playlists, this.cbShowPosition.isSelected(), this.cbShowTimeAndEntries.isSelected()){

            @Override
            public void reloadList(Node node) {
                super.reloadList(node);
                PlaylistTopComponent.this.reloadList(node);
            }
        };
        AbstractNode abstractNode = new AbstractNode(this, Children.create((ChildFactory)playlistChildFactory, (boolean)false)){

            public Action[] getActions(boolean context) {
                return new Action[]{SystemAction.get(ReloadPlaylistAction.class), SystemAction.get(CreatePlaylistAction.class)};
            }

            public Image getIcon(int type) {
                return ImageUtilities.loadImage((String)"icons/notes.png");
            }

            public Image getOpenedIcon(int type) {
                return this.getIcon(-1);
            }
        };
        em.setRootContext((Node)abstractNode);
        String displayname = "Playlists [" + playlists.size() + "] ";
        Playlist defaultPlaylist = this.ps.getDefaultPlaylist(Scenerixx.unlocked);
        if (defaultPlaylist.getId() != null) {
            displayname = displayname + " [Default: '" + defaultPlaylist.getName() + "']";
        }
        em.getRootContext().setDisplayName(displayname);
        SwingUtilities.invokeLater(() -> this.setName(Bundle.CTL_PlaylistTopComponent() + " [" + playlists.size() + "]"));
    }

    public void createNewPlaylist() {
        Playlist p = new Playlist();
        p.setName("[New Playlist]");
        this.db.getEntityService().save((AbstractEntity)p);
        this.reloadList(p.getName());
    }

    public void setDirty() {
        this.setDirty(false);
    }

    public void setDirty(boolean clearList) {
        this.lbStatus.setVisible(true);
        this.lbStatus.setText("View might be out of sync!");
        this.btnReload.setVisible(true);
        if (clearList) {
            this.setRootContext(new ArrayList<Playlist>());
        }
    }
}

