/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types;

import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpressionBase;
import com.querydsl.core.types.Visitor;
import com.querydsl.core.types.dsl.EntityPathBase;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class SimpleDTOProjection<T>
extends FactoryExpressionBase<T> {
    private final List<Expression<?>> expressions;
    private final Constructor<? extends T> constructor;

    public SimpleDTOProjection(Class<? extends T> type, EntityPathBase<?> entity) {
        super(type);
        this.expressions = this.generateExpressions(type, entity);
        this.constructor = this.findMatchingConstructor(type);
    }

    private List<Expression<?>> generateExpressions(Class<? extends T> dtoType, EntityPathBase<?> entity) {
        ArrayList expressions = new ArrayList();
        for (Field field : dtoType.getDeclaredFields()) {
            String fieldName = field.getName();
            try {
                Object value;
                Field entityField = entity.getClass().getField(fieldName);
                if (entityField == null || !((value = entityField.get(entity)) instanceof Expression)) continue;
                Expression expression = (Expression)value;
                expressions.add(expression);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return expressions;
    }

    private Constructor<? extends T> findMatchingConstructor(Class<? extends T> type) {
        for (Constructor<?> constructor : type.getDeclaredConstructors()) {
            if (constructor.getParameterTypes().length != this.expressions.size()) continue;
            return constructor;
        }
        throw new RuntimeException("No matching constructor found for " + type.getSimpleName());
    }

    @Override
    public T newInstance(Object ... args) {
        try {
            return this.constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create instance of " + this.getType().getSimpleName(), e);
        }
    }

    @Override
    public List<Expression<?>> getArgs() {
        return this.expressions;
    }

    @Override
    public <R, C> R accept(Visitor<R, C> v, C context) {
        return null;
    }

    public static <T> SimpleDTOProjection<T> fields(Class<? extends T> type, EntityPathBase<?> entity) {
        return new SimpleDTOProjection<T>(type, entity);
    }
}

