/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.core.types.dsl;

import com.querydsl.core.types.ConstantImpl;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.dsl.Coalesce;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.TemporalExpression;
import java.sql.Time;
import org.jetbrains.annotations.Nullable;

public abstract class TimeExpression<T extends Comparable>
extends TemporalExpression<T> {
    private static final long serialVersionUID = 7360552308332457990L;
    @Nullable
    private volatile transient NumberExpression<Integer> hours;
    @Nullable
    private volatile transient NumberExpression<Integer> minutes;
    @Nullable
    private volatile transient NumberExpression<Integer> milliseconds;
    @Nullable
    private volatile transient NumberExpression<Float> seconds;

    public TimeExpression(Expression<T> mixin) {
        super(mixin);
    }

    @Override
    public TimeExpression<T> as(Path<T> alias) {
        return Expressions.timeOperation(this.getType(), Ops.ALIAS, this.mixin, alias);
    }

    @Override
    public TimeExpression<T> as(String alias) {
        return this.as(ExpressionUtils.path(this.getType(), alias));
    }

    public NumberExpression<Integer> hour() {
        if (this.hours == null) {
            this.hours = Expressions.numberOperation(Integer.class, Ops.DateTimeOps.HOUR, this.mixin);
        }
        return this.hours;
    }

    public NumberExpression<Integer> minute() {
        if (this.minutes == null) {
            this.minutes = Expressions.numberOperation(Integer.class, Ops.DateTimeOps.MINUTE, this.mixin);
        }
        return this.minutes;
    }

    public NumberExpression<Float> second() {
        if (this.seconds == null) {
            this.seconds = Expressions.numberOperation(Float.class, Ops.DateTimeOps.SECOND, this.mixin);
        }
        return this.seconds;
    }

    public NumberExpression<Integer> milliSecond() {
        if (this.milliseconds == null) {
            this.milliseconds = Expressions.numberOperation(Integer.class, Ops.DateTimeOps.MILLISECOND, this.mixin);
        }
        return this.milliseconds;
    }

    public static TimeExpression<Time> currentTime() {
        return Constants.CURRENT_TIME;
    }

    public static <T extends Comparable> TimeExpression<T> currentTime(Class<T> cl) {
        return Expressions.timeOperation(cl, Ops.DateTimeOps.CURRENT_TIME, new Expression[0]);
    }

    @Override
    public TimeExpression<T> nullif(Expression<T> other) {
        return Expressions.timeOperation(this.getType(), Ops.NULLIF, this.mixin, other);
    }

    @Override
    public TimeExpression<T> nullif(T other) {
        return this.nullif((Expression)ConstantImpl.create(other));
    }

    @Override
    public TimeExpression<T> coalesce(Expression<T> expr) {
        Coalesce<Expression<T>> coalesce = new Coalesce<Expression<T>>(this.getType(), this.mixin);
        coalesce.add(expr);
        return coalesce.asTime();
    }

    @Override
    public TimeExpression<T> coalesce(Expression<T> ... exprs) {
        Coalesce<Expression<T>> coalesce = new Coalesce<Expression<T>>(this.getType(), this.mixin);
        for (Expression<T> expr : exprs) {
            coalesce.add(expr);
        }
        return coalesce.asTime();
    }

    @Override
    public TimeExpression<T> coalesce(T arg) {
        Coalesce<T> coalesce = new Coalesce<T>(this.getType(), this.mixin);
        coalesce.add(arg);
        return coalesce.asTime();
    }

    @Override
    public TimeExpression<T> coalesce(T ... args) {
        Coalesce<T> coalesce = new Coalesce<T>(this.getType(), this.mixin);
        for (T arg : args) {
            coalesce.add(arg);
        }
        return coalesce.asTime();
    }

    private static class Constants {
        private static final TimeExpression<Time> CURRENT_TIME = TimeExpression.currentTime(Time.class);

        private Constants() {
        }
    }
}

