(function () {
    var darkSwitch = document.getElementById("darkSwitch");
    if (darkSwitch) {
        initTheme();
        darkSwitch.addEventListener("change", function (event) {
            resetTheme();
        });
        function initTheme() {


            if (localStorage.getItem("darkSwitch") === null) {
                // use dark as default theme
                localStorage.setItem("darkSwitch", "dark");
            }


            var darkThemeSelected =
                    localStorage.getItem("darkSwitch") !== null &&
                    localStorage.getItem("darkSwitch") === "dark";
            darkSwitch.checked = darkThemeSelected;
            darkThemeSelected
                    ? document.body.setAttribute("data-theme", "dark")
                    : document.body.removeAttribute("data-theme");
        }
        function resetTheme() {
            if (darkSwitch.checked) {
                document.body.setAttribute("data-theme", "dark");
                localStorage.setItem("darkSwitch", "dark");
                localStorage.removeItem("lightSwitch");
            } else {
                document.body.removeAttribute("data-theme");
                localStorage.removeItem("darkSwitch");
                localStorage.setItem("lightSwitch", "light");
            }
        }
    }
})();